/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.api.mana.ILens;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.mana.TilePrism;

import javax.annotation.Nonnull;
import net.minecraft.class_1059;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class RenderTilePrism extends class_827<TilePrism> {

	public RenderTilePrism(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nonnull TilePrism prism, float partTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		float pos = (float) Math.sin((ClientTickHandler.ticksInGame + partTicks) * 0.05F) * 0.5F * (1F - 1F / 16F) - 0.5F;

		class_1799 stack = prism.getItemHandler().method_5438(0);

		if (!stack.method_7960()) {
			class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
			if (stack.method_7909() instanceof ILens) {
				ms.method_22903();
				ms.method_22907(class_1160.field_20703.method_23214(90));
				ms.method_22904(0.5F, 0.5F, pos);
				class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4315, light, overlay, ms, buffers);
				ms.method_22909();
			}
		}
	}

}
