/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.api.mana.IPoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.helper.ColorHelper;

import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_824;
import net.minecraft.class_827;
import java.util.Random;

public class RenderTilePool extends class_827<TilePool> {

	// Overrides for when we call this TESR from a cart
	public static int cartMana = -1;

	public RenderTilePool(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nullable TilePool pool, float f, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();

		boolean fab = pool != null && ((BlockPool) pool.method_11010().method_26204()).variant == BlockPool.Variant.FABULOUS;

		if (fab) {
			float time = ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
			time += new Random(pool.method_11016().method_10263() ^ pool.method_11016().method_10264() ^ pool.method_11016().method_10260()).nextInt(100000);
			time *= 0.005F;
			int poolColor = ColorHelper.getColorValue(pool.color);
			int color = vazkii.botania.common.core.helper.MathHelper.multiplyColor(class_3532.method_15369(class_3532.method_22450(time), 0.6F, 1F), poolColor);

			int red = (color & 0xFF0000) >> 16;
			int green = (color & 0xFF00) >> 8;
			int blue = color & 0xFF;
			class_2680 state = pool.method_11010();
			class_1087 model = class_310.method_1551().method_1541().method_3351().method_3335(state);
			class_4588 buffer = buffers.getBuffer(class_4696.method_23683(state, false));
			class_310.method_1551().method_1541().method_3350()
					.method_3367(ms.method_23760(), buffer, state, model, red / 255F, green / 255F, blue / 255F, light, overlay);
		}

		ms.method_22904(0.5F, 1.5F, 0.5F);

		int mana = pool == null ? cartMana : pool.getCurrentMana();
		int cap = pool == null ? -1 : pool.manaCap;
		if (cap == -1) {
			cap = TilePool.MAX_MANA;
		}

		float waterLevel = (float) mana / (float) cap * 0.4F;

		float s = 1F / 16F;
		float v = 1F / 8F;
		float w = -v * 3.5F;

		if (pool != null) {
			class_2248 below = pool.method_10997().method_8320(pool.method_11016().method_10074()).method_26204();
			if (below instanceof IPoolOverlayProvider) {
				class_1058 overlayIcon = ((IPoolOverlayProvider) below).getIcon(pool.method_10997(), pool.method_11016());
				if (overlayIcon != null) {
					ms.method_22903();
					float alpha = (float) ((Math.sin((ClientTickHandler.ticksInGame + f) / 20.0) + 1) * 0.3 + 0.2);
					ms.method_22904(-0.5F, -1F - 0.43F, -0.5F);
					ms.method_22907(class_1160.field_20703.method_23214(90F));
					ms.method_22905(s, s, s);

					class_4588 buffer = buffers.getBuffer(RenderHelper.ICON_OVERLAY);
					IconHelper.renderIcon(ms, buffer, 0, 0, overlayIcon, 16, 16, alpha);

					ms.method_22909();
				}
			}
		}

		if (waterLevel > 0) {
			s = 1F / 256F * 14F;
			ms.method_22903();
			ms.method_22904(w, -1F - (0.43F - waterLevel), w);
			ms.method_22907(class_1160.field_20703.method_23214(90F));
			ms.method_22905(s, s, s);

			class_4588 buffer = buffers.getBuffer(RenderHelper.MANA_POOL_WATER);
			IconHelper.renderIcon(ms, buffer, 0, 0, MiscellaneousIcons.INSTANCE.manaWater.method_24148(), 16, 16, 1);

			ms.method_22909();
		}
		ms.method_22909();

		cartMana = -1;
	}

}
