/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import com.google.common.collect.ImmutableMap;
import vazkii.botania.common.block.tile.TileIncensePlate;

import javax.annotation.Nonnull;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;
import java.util.Map;

public class RenderTileIncensePlate extends class_827<TileIncensePlate> {

	private static final Map<class_2350, Integer> ROTATIONS = ImmutableMap.of(class_2350.field_11043, 180, class_2350.field_11035, 0, class_2350.field_11039, 270, class_2350.field_11034, 90);

	public RenderTileIncensePlate(class_824 manager) {
		super(manager);
	}

	@SuppressWarnings("deprecation")
	@Override
	public void render(@Nonnull TileIncensePlate plate, float ticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		class_1799 stack = plate.getItemHandler().method_5438(0);
		if (stack.method_7960()) {
			return;
		}

		class_2350 facing = plate.method_11010().method_11654(class_2741.field_12481);

		ms.method_22903();
		ms.method_22904(0.5F, 1.5F, 0.5F);
		ms.method_22907(class_1160.field_20705.method_23214(ROTATIONS.get(facing)));
		float s = 0.6F;
		ms.method_22904(-0.11F, -1.35F, 0F);
		ms.method_22905(s, s, s);
		class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4318, light, overlay, ms, buffers);
		ms.method_22909();
	}

}
