/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import com.mojang.authlib.GameProfile;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.helper.ShaderWrappedRenderLayer;
import vazkii.botania.client.render.entity.RenderDoppleganger;
import vazkii.botania.mixin.AccessorSkullTileEntityRenderer;

import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1548;
import net.minecraft.class_1613;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2484;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_607;
import net.minecraft.class_824;
import net.minecraft.class_836;

public class RenderTileGaiaHead extends class_836 {
	public RenderTileGaiaHead(class_824 manager) {
		super(manager);
	}

	// [VanillaCopy] super, but finding the skull type and profile ourselves and calling our own method to get RenderType
	public static void gaiaRender(@Nullable class_2350 facing, float rotation, float animationProgress, class_4587 ms, class_4597 buffers, int light) {
		class_1297 view = class_310.method_1551().method_1560();
		class_2484.class_2485 type = class_2484.class_2486.field_11510;
		GameProfile profile = null;

		if (view instanceof class_1657) {
			profile = ((class_1657) view).method_7334();
		} else if (view instanceof class_1613) {
			type = class_2484.class_2486.field_11512;
		} else if (view instanceof class_1639) {
			type = class_2484.class_2486.field_11513;
		} else if (view instanceof class_1528) {
			type = class_2484.class_2486.field_11513;
		} else if (view instanceof class_1642) {
			type = class_2484.class_2486.field_11508;
		} else if (view instanceof class_1548) {
			type = class_2484.class_2486.field_11507;
		} else if (view instanceof class_1510) {
			type = class_2484.class_2486.field_11511;
		}

		class_607 genericheadmodel = AccessorSkullTileEntityRenderer.getModels().get(type);
		ms.method_22903();
		if (facing == null) {
			ms.method_22904(0.5D, 0.0D, 0.5D);
		} else {
			switch (facing) {
			case field_11043:
				ms.method_22904(0.5D, 0.25D, 0.74D);
				break;
			case field_11035:
				ms.method_22904(0.5D, 0.25D, 0.26D);
				break;
			case field_11039:
				ms.method_22904(0.74D, 0.25D, 0.5D);
				break;
			case field_11034:
			default:
				ms.method_22904(0.26D, 0.25D, 0.5D);
			}
		}

		ms.method_22905(-1.0F, -1.0F, 1.0F);
		class_1921 layer = AccessorSkullTileEntityRenderer.botania_getRenderType(type, profile);
		if (ShaderHelper.useShaders()) {
			layer = new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.DOPPLEGANGER, RenderDoppleganger.defaultCallback, layer);
		}
		class_4588 ivertexbuilder = buffers.getBuffer(layer);
		genericheadmodel.method_2821(animationProgress, rotation, 0.0F);
		genericheadmodel.method_2828(ms, ivertexbuilder, light, class_4608.field_21444, 1.0F, 1.0F, 1.0F, 1.0F);
		ms.method_22909();
	}
}
