/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.TileFloatingFlower;
import vazkii.botania.common.core.handler.ConfigHandler;

import javax.annotation.Nonnull;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_827;
import java.util.Random;

public class RenderTileFloatingFlower extends class_827<TileFloatingFlower> {

	public RenderTileFloatingFlower(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nonnull TileFloatingFlower tile, float t, class_4587 ms, class_4597 buffers, int light, int overlay) {
		renderFloatingIsland(tile, t, ms, buffers, light, overlay);
	}

	public static void renderFloatingIsland(class_2586 tile, float t, class_4587 ms, class_4597 buffers, int light, int overlay) {
		if (ConfigHandler.CLIENT.staticFloaters.getValue()) {
			return;
		}

		// todo 1.16-fabric IModelData data = tile.getModelData();
		if (true/* todo 1.16-fabric !data.hasProperty(BotaniaStateProps.FLOATING_DATA)*/) {
			return;
		}

		ms.method_22903();

		double worldTime = ClientTickHandler.ticksInGame + t;
		if (tile.method_10997() != null) {
			worldTime += new Random(tile.method_11016().hashCode()).nextInt(1000);
		}

		ms.method_22904(0.5F, 0, 0.5F);
		ms.method_22907(class_1160.field_20705.method_23214(-((float) worldTime * 0.5F)));
		ms.method_22904(-0.5, (float) Math.sin(worldTime * 0.05F) * 0.1F, 0.5);

		ms.method_22907(class_1160.field_20703.method_23214(4F * (float) Math.sin(worldTime * 0.04F)));
		ms.method_22907(class_1160.field_20705.method_23214(90.0F));

		class_776 brd = class_310.method_1551().method_1541();
		class_2680 state = tile.method_11010();

		class_1087 ibakedmodel = brd.method_3349(state);
		brd.method_3350().method_3367(ms.method_23760(), buffers.getBuffer(class_4696.method_23683(state, false)), state, ibakedmodel, 1, 1, 1, light, overlay);

		ms.method_22909();
	}

}
