/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;

import javax.annotation.Nullable;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class RenderTileCorporeaIndex extends class_827<TileCorporeaIndex> {
	private static final class_1921 LAYER = class_1921.method_23578(new class_2960(LibResources.MODEL_CORPOREA_INDEX));
	private static final float ANGLE = (float) Math.sin(Math.toRadians(45));
	private final class_630 ring;
	private final class_630 cube;

	public RenderTileCorporeaIndex(class_824 manager) {
		super(manager);
		this.ring = new class_630(64, 32, 0, 0);
		this.ring.method_2844(-4.0F, -4.0F, -4.0F, 8.0F, 8.0F, 8.0F);
		this.cube = new class_630(64, 32, 32, 0);
		this.cube.method_2844(-4.0F, -4.0F, -4.0F, 8.0F, 8.0F, 8.0F);
	}

	@Override
	public void render(@Nullable TileCorporeaIndex index, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		ms.method_22904(0.5, 0, 0.5);
		float translation = index != null ? (float) ((Math.cos((index.ticksWithCloseby + (index.hasCloseby ? partialTicks : 0)) / 10F) * 0.5 + 0.5) * 0.25) : 0F;
		float rotation = index != null ? index.ticks * 2 + partialTicks : 0F;
		class_4588 buffer = buffers.getBuffer(LAYER);
		ms.method_22903();
		ms.method_22904(0.0D, -1, 0.0D);

		ms.method_22907(class_1160.field_20705.method_23214(rotation));
		ms.method_22904(0.0D, 1.5F + translation / 2.0F, 0.0D);
		ms.method_22907(new class_1158(new class_1160(ANGLE, 0.0F, ANGLE), 60.0F, true));
		this.ring.method_22698(ms, buffer, light, overlay);
		ms.method_22905(0.875F, 0.875F, 0.875F);
		ms.method_22907(new class_1158(new class_1160(ANGLE, 0.0F, ANGLE), 60.0F, true));
		ms.method_22907(class_1160.field_20705.method_23214(rotation));
		this.ring.method_22698(ms, buffer, light, overlay);
		ms.method_22905(0.875F, 0.875F, 0.875F);
		ms.method_22907(new class_1158(new class_1160(ANGLE, 0.0F, ANGLE), 60.0F, true));
		ms.method_22907(class_1160.field_20705.method_23214(rotation));
		this.cube.method_22698(ms, buffer, light, overlay);
		ms.method_22909();

		if (index != null && index.closeby > 0F) {
			float starScale = 0.02F;
			float starRadius = (float) TileCorporeaIndex.RADIUS * index.closeby + (index.closeby == 1F ? 0F : index.hasCloseby ? partialTicks : -partialTicks) * 0.2F;
			double rads = (index.ticksWithCloseby + partialTicks) * 2 * Math.PI / 180;
			double starX = Math.cos(rads) * starRadius;
			double starZ = Math.sin(rads) * starRadius;
			int color = 0xFF00FF;
			int seed = index.method_11016().method_10263() ^ index.method_11016().method_10264() ^ index.method_11016().method_10260();

			ms.method_22904(starX, 0.3, starZ);
			RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
			ms.method_22904(-starX * 2, 0, -starZ * 2);
			RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
			ms.method_22904(starX, 0, starZ);

			rads = -rads;
			starX = Math.cos(rads) * starRadius;
			starZ = Math.sin(rads) * starRadius;
			ms.method_22904(starX, 0, starZ);
			RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
			ms.method_22904(-starX * 2, 0, -starZ * 2);
			RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
			ms.method_22904(starX, 0, starZ);
		}
		ms.method_22909();
	}

}
