/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.common.block.tile.TileCocoon;

import javax.annotation.Nonnull;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class RenderTileCocoon extends class_827<TileCocoon> {

	public RenderTileCocoon(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nonnull TileCocoon cocoon, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		float rot = 0F;
		float modval = 60F - (float) cocoon.timePassed / (float) TileCocoon.TOTAL_TIME * 30F;
		if (cocoon.timePassed % modval < 10) {
			float mod = (cocoon.timePassed + partialTicks) % modval;
			float v = mod / 5 * (float) Math.PI * 2;
			rot = (float) Math.sin(v) * (float) Math.log(cocoon.timePassed + partialTicks);
		}

		ms.method_22903();
		ms.method_22904(0.5, 0, 0);
		ms.method_22907(class_1160.field_20703.method_23214(rot));
		ms.method_22904(-0.5, 0, 0);
		class_2680 state = cocoon.method_11010();
		class_1087 model = class_310.method_1551().method_1541().method_3351().method_3335(state);
		class_4588 buffer = buffers.getBuffer(class_4696.method_23679(state));
		class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffer, state, model, 1, 1, 1, light, overlay);
		ms.method_22909();
	}
}
