/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.client.lib.LibResources;
import vazkii.botania.client.model.ModelBellows;
import vazkii.botania.common.block.tile.mana.TileBellows;

import javax.annotation.Nullable;
import net.minecraft.class_1160;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class RenderTileBellows extends class_827<TileBellows> {
	private static final class_2960 texture = new class_2960(LibResources.MODEL_BELLOWS);
	private static final ModelBellows model = new ModelBellows();

	public RenderTileBellows(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nullable TileBellows bellows, float f, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		ms.method_22904(0.5F, 1.5F, 0.5F);
		ms.method_22905(1F, -1F, -1F);
		float angle = 0;
		if (bellows != null) {
			switch (bellows.method_11010().method_11654(class_2741.field_12481)) {
			case field_11035:
				break;
			case field_11043:
				angle = 180F;
				break;
			case field_11034:
				angle = 270F;
				break;
			case field_11039:
				angle = 90F;
				break;
			}
		}
		ms.method_22907(class_1160.field_20705.method_23214(angle));
		float fract = Math.max(0.1F, 1F - (bellows == null ? 0 : bellows.movePos + bellows.moving * f + 0.1F));
		class_4588 buffer = buffers.getBuffer(model.method_23500(texture));
		model.render(ms, buffer, light, overlay, 1, 1, 1, 1, fract);
		ms.method_22909();
	}

}
