/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.client.model.ModelAvatar;
import vazkii.botania.common.block.tile.TileAvatar;

import javax.annotation.Nullable;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class RenderTileAvatar extends class_827<TileAvatar> {

	private static final float[] ROTATIONS = new float[] {
			180F, 0F, 90F, 270F
	};

	private static final class_2960 texture = new class_2960(LibResources.MODEL_AVATAR);
	private static final ModelAvatar model = new ModelAvatar();

	public RenderTileAvatar(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nullable TileAvatar avatar, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		class_2350 facing = avatar != null && avatar.method_10997() != null ? avatar.method_11010().method_11654(class_2741.field_12481) : class_2350.field_11035;

		ms.method_22904(0.5F, 1.6F, 0.5F);
		ms.method_22905(1F, -1F, -1F);
		ms.method_22907(class_1160.field_20705.method_23214(ROTATIONS[Math.max(Math.min(ROTATIONS.length - 1, facing.method_10146() - 2), 0)]));
		class_4588 buffer = buffers.getBuffer(model.method_23500(texture));
		model.method_2828(ms, buffer, light, overlay, 1, 1, 1, 1);

		if (avatar != null) {
			class_1799 stack = avatar.getItemHandler().method_5438(0);
			if (!stack.method_7960()) {
				ms.method_22903();
				float s = 0.6F;
				ms.method_22905(s, s, s);
				ms.method_22904(-0.5F, 2F, -0.25F);
				ms.method_22907(class_1160.field_20703.method_23214(-70));
				class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4320, light, overlay, ms, buffers);
				ms.method_22909();

				IAvatarWieldable wieldable = (IAvatarWieldable) stack.method_7909();
				buffer = buffers.getBuffer(class_1921.method_23580(wieldable.getOverlayResource(avatar, stack)));
				s = 1.01F;

				ms.method_22903();
				ms.method_22905(s, s, s);
				ms.method_22904(0F, -0.01F, 0F);
				float alpha = (float) Math.sin(ClientTickHandler.ticksInGame / 20D) / 2F + 0.5F;
				model.method_2828(ms, buffer, 0xF000F0, overlay, 1, 1, 1, alpha + 0.183F);
				ms.method_22909();
			}
		}
		ms.method_22909();
	}

}
