/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.api.item.IPetalApothecary;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.TileAltar;

import javax.annotation.Nonnull;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1163;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class RenderTileAltar extends class_827<TileAltar> {

	public RenderTileAltar(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nonnull TileAltar altar, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		ms.method_22904(0.5, 1.5, 0.5);

		boolean water = altar.getFluid() == IPetalApothecary.State.WATER;
		boolean lava = altar.getFluid() == IPetalApothecary.State.LAVA;
		if (water || lava) {
			ms.method_22903();
			float s = 1F / 256F * 10F;
			float v = 1F / 8F;
			float w = -v * 2.5F;

			if (water) {
				int petals = 0;
				for (int i = 0; i < altar.inventorySize(); i++) {
					if (!altar.getItemHandler().method_5438(i).method_7960()) {
						petals++;
					} else {
						break;
					}
				}

				if (petals > 0) {
					final float modifier = 6F;
					final float rotationModifier = 0.25F;
					final float radiusBase = 1.2F;
					final float radiusMod = 0.1F;

					double ticks = (ClientTickHandler.ticksInGame + pticks) * 0.5;
					float offsetPerPetal = 360 / petals;

					ms.method_22903();
					ms.method_22904(-0.05F, -0.5F, 0F);
					ms.method_22905(v, v, v);
					for (int i = 0; i < petals; i++) {
						float offset = offsetPerPetal * i;
						float deg = (int) (ticks / rotationModifier % 360F + offset);
						float rad = deg * (float) Math.PI / 180F;
						float radiusX = (float) (radiusBase + radiusMod * Math.sin(ticks / modifier));
						float radiusZ = (float) (radiusBase + radiusMod * Math.cos(ticks / modifier));
						float x = (float) (radiusX * Math.cos(rad));
						float z = (float) (radiusZ * Math.sin(rad));
						float y = (float) Math.cos((ticks + 50 * i) / 5F) / 10F;

						ms.method_22903();
						ms.method_22904(x, y, z);
						float xRotate = (float) Math.sin(ticks * rotationModifier) / 2F;
						float yRotate = (float) Math.max(0.6F, Math.sin(ticks * 0.1F) / 2F + 0.5F);
						float zRotate = (float) Math.cos(ticks * rotationModifier) / 2F;

						v /= 2F;
						ms.method_22904(v, v, v);
						ms.method_22907(new class_1160(xRotate, yRotate, zRotate).method_23214(deg));
						ms.method_22904(-v, -v, -v);
						v *= 2F;

						class_1799 stack = altar.getItemHandler().method_5438(i);
						class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4318, light, overlay, ms, buffers);
						ms.method_22909();
					}

					ms.method_22909();
				}
			}

			float alpha = lava ? 1F : 0.7F;

			ms.method_22904(w, -0.3F, w);
			ms.method_22907(class_1160.field_20703.method_23214(90));
			ms.method_22905(s, s, s);

			class_1058 sprite = lava ? class_310.method_1551().method_1554().method_4743().method_3335(class_2246.field_10164.method_9564()).method_4711()
					: class_310.method_1551().method_1554().method_4743().method_3335(class_2246.field_10382.method_9564()).method_4711();
			int color = lava ? -1
					: class_1163.method_4961(altar.method_10997(), altar.method_11016());
			class_4588 buffer = buffers.getBuffer(class_4722.method_24076());
			renderIcon(ms, buffer, sprite, color, alpha, overlay, lava ? 0xF000F0 : light);
			ms.method_22909();
		}
		ms.method_22909();
	}

	private void renderIcon(class_4587 ms, class_4588 builder, class_1058 sprite, int color, float alpha, int overlay, int light) {
		int red = ((color >> 16) & 0xFF);
		int green = ((color >> 8) & 0xFF);
		int blue = (color & 0xFF);
		class_1159 mat = ms.method_23760().method_23761();
		builder.method_22918(mat, 0, 16, 0).method_1336(red, green, blue, (int) (alpha * 255F)).method_22913(sprite.method_4594(), sprite.method_4575()).method_22922(overlay).method_22916(light).method_22914(0, 0, 1).method_1344();
		builder.method_22918(mat, 16, 16, 0).method_1336(red, green, blue, (int) (alpha * 255F)).method_22913(sprite.method_4577(), sprite.method_4575()).method_22922(overlay).method_22916(light).method_22914(0, 0, 1).method_1344();
		builder.method_22918(mat, 16, 0, 0).method_1336(red, green, blue, (int) (alpha * 255F)).method_22913(sprite.method_4577(), sprite.method_4593()).method_22922(overlay).method_22916(light).method_22914(0, 0, 1).method_1344();
		builder.method_22918(mat, 0, 0, 0).method_1336(red, green, blue, (int) (alpha * 255F)).method_22913(sprite.method_4594(), sprite.method_4593()).method_22922(overlay).method_22916(light).method_22914(0, 0, 1).method_1344();
	}

}
