/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_897;
import net.minecraft.class_898;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.EntityManaStorm;

import javax.annotation.Nonnull;

public class RenderManaStorm extends class_897<EntityManaStorm> {

	public RenderManaStorm(class_898 renderManager, EntityRendererRegistry.Context ctx) {
		super(renderManager);
	}

	@Override
	public void render(EntityManaStorm storm, float yaw, float pticks, class_4587 ms, class_4597 buffers, int light) {
		ms.method_22903();
		float maxScale = 1.95F;
		float scale = 0.05F + ((float) storm.burstsFired / EntityManaStorm.TOTAL_BURSTS - (storm.deathTime == 0 ? 0 : storm.deathTime + pticks) / EntityManaStorm.DEATH_TIME) * maxScale;
		RenderHelper.renderStar(ms, buffers, 0x00FF00, scale, scale, scale, storm.method_5667().getMostSignificantBits());
		ms.method_22909();
	}

	@Nonnull
	@Override
	public class_2960 getTexture(@Nonnull EntityManaStorm entity) {
		return class_1059.field_5275;
	}

}
