/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.systems.RenderSystem;

import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.minecraft.class_1068;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.minecraft.class_898;
import net.minecraft.class_909;
import vazkii.botania.client.core.helper.ShaderCallback;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.helper.ShaderWrappedRenderLayer;
import vazkii.botania.common.entity.EntityDoppleganger;

import javax.annotation.Nonnull;

public class RenderDoppleganger extends class_909<EntityDoppleganger, class_572<EntityDoppleganger>> {

	private static final float DEFAULT_GRAIN_INTENSITY = 0.05F;
	private static final float DEFAULT_DISFIGURATION = 0.025F;

	private static float grainIntensity = DEFAULT_GRAIN_INTENSITY;
	private static float disfiguration = DEFAULT_DISFIGURATION;

	private static final ShaderCallback CALLBACK = shader -> {
		// Frag Uniforms
		int disfigurationUniform = class_4493.method_21990(shader, "disfiguration");
		ShaderHelper.FLOAT_BUF.position(0);
		ShaderHelper.FLOAT_BUF.put(0, disfiguration);
		RenderSystem.glUniform1(disfigurationUniform, ShaderHelper.FLOAT_BUF);

		// Vert Uniforms
		int grainIntensityUniform = class_4493.method_21990(shader, "grainIntensity");
		ShaderHelper.FLOAT_BUF.position(0);
		ShaderHelper.FLOAT_BUF.put(0, grainIntensity);
		RenderSystem.glUniform1(grainIntensityUniform, ShaderHelper.FLOAT_BUF);
	};

	public static final ShaderCallback defaultCallback = shader -> {
		// Frag Uniforms
		int disfigurationUniform = class_4493.method_21990(shader, "disfiguration");
		ShaderHelper.FLOAT_BUF.position(0);
		ShaderHelper.FLOAT_BUF.put(0, DEFAULT_DISFIGURATION);
		RenderSystem.glUniform1(disfigurationUniform, ShaderHelper.FLOAT_BUF);

		// Vert Uniforms
		int grainIntensityUniform = class_4493.method_21990(shader, "grainIntensity");
		ShaderHelper.FLOAT_BUF.position(0);
		ShaderHelper.FLOAT_BUF.put(0, DEFAULT_GRAIN_INTENSITY);
		RenderSystem.glUniform1(grainIntensityUniform, ShaderHelper.FLOAT_BUF);
	};

	public RenderDoppleganger(class_898 renderManager, EntityRendererRegistry.Context ctx) {
		super(renderManager, new Model(), 0F);
	}

	@Override
	public void render(@Nonnull EntityDoppleganger dopple, float yaw, float partialTicks, class_4587 ms, class_4597 buffers, int light) {
		int invulTime = dopple.getInvulTime();
		if (invulTime > 0) {
			grainIntensity = invulTime > 20 ? 1F : invulTime * 0.05F;
			disfiguration = grainIntensity * 0.3F;
		} else {
			disfiguration = (0.025F + dopple.field_6235 * ((1F - 0.15F) / 20F)) / 2F;
			grainIntensity = 0.05F + dopple.field_6235 * ((1F - 0.15F) / 10F);
		}

		super.method_4072(dopple, yaw, partialTicks, ms, buffers, light);
	}

	@Nonnull
	@Override
	public class_2960 getTexture(@Nonnull EntityDoppleganger entity) {
		class_310 mc = class_310.method_1551();

		if (!(mc.method_1560() instanceof class_742)) {
			return class_1068.method_4648(entity.method_5667());
		}

		return ((class_742) mc.method_1560()).method_3117();
	}

	@Override
	protected boolean isVisible(EntityDoppleganger dopple) {
		return true;
	}

	private static class Model extends class_572<EntityDoppleganger> {
		private static class_1921 makeRenderType(class_2960 texture) {
			class_1921 normal = class_1921.method_23580(texture);
			return ShaderHelper.useShaders()
					? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.DOPPLEGANGER, CALLBACK, normal)
					: normal;
		}

		Model() {
			super(Model::makeRenderType, 0, 0, 64, 64);
		}
	}

}
