/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_897;
import net.minecraft.class_898;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.EntityBabylonWeapon;

import javax.annotation.Nonnull;

import java.util.Random;

public class RenderBabylonWeapon extends class_897<EntityBabylonWeapon> {

	public RenderBabylonWeapon(class_898 renderManager, EntityRendererRegistry.Context ctx) {
		super(renderManager);
	}

	@Override
	public void render(@Nonnull EntityBabylonWeapon weapon, float yaw, float partialTicks, class_4587 ms, class_4597 buffers, int light) {
		ms.method_22903();
		ms.method_22907(class_1160.field_20705.method_23214(weapon.getRotation()));

		int live = weapon.getLiveTicks();
		int delay = weapon.getDelay();
		float charge = Math.min(10F, Math.max(live, weapon.getChargeTicks()) + partialTicks);
		float chargeMul = charge / 10F;

		ms.method_22903();
		float s = 1.5F;
		ms.method_22905(s, s, s);
		ms.method_22907(class_1160.field_20705.method_23214(90F));

		class_1087 model = MiscellaneousIcons.INSTANCE.kingKeyWeaponModels[weapon.getVariety()];
		class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffers.getBuffer(class_4722.method_29382()), null, model, 1, 1, 1, 0xF000F0, class_4608.field_21444);
		ms.method_22909();

		Random rand = new Random(weapon.method_5667().getMostSignificantBits());
		ms.method_22907(class_1160.field_20703.method_23214(-90F));
		ms.method_22904(0F, -0.3F + rand.nextFloat() * 0.1F, 1F);

		s = chargeMul;
		if (live > delay) {
			s -= Math.min(1F, (live - delay + partialTicks) * 0.2F);
		}
		s *= 2F;
		ms.method_22905(s, s, s);

		ms.method_22907(class_1160.field_20705.method_23214(charge * 9F + (weapon.field_6012 + partialTicks) * 0.5F + rand.nextFloat() * 360F));

		class_4588 buffer = buffers.getBuffer(RenderHelper.BABYLON_ICON);
		class_1159 mat = ms.method_23760().method_23761();
		buffer.method_22918(mat, -1, 0, -1).method_22915(1, 1, 1, chargeMul).method_22913(0, 0).method_1344();
		buffer.method_22918(mat, -1, 0, 1).method_22915(1, 1, 1, chargeMul).method_22913(0, 1).method_1344();
		buffer.method_22918(mat, 1, 0, 1).method_22915(1, 1, 1, chargeMul).method_22913(1, 1).method_1344();
		buffer.method_22918(mat, 1, 0, -1).method_22915(1, 1, 1, chargeMul).method_22913(1, 0).method_1344();

		ms.method_22909();
	}

	@Nonnull
	@Override
	public class_2960 getTexture(@Nonnull EntityBabylonWeapon entity) {
		return class_1059.field_5275;
	}

}
