/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.patchouli.processor;

import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class PetalApothecaryProcessor implements IComponentProcessor {
	protected class_1860<?> recipe;

	@Override
	public void setup(IVariableProvider variables) {
		class_2960 id = new class_2960(variables.get("recipe").asString());
		this.recipe = ModRecipeTypes.getRecipes(class_310.method_1551().field_1687, ModRecipeTypes.PETAL_TYPE).get(id);
		if (recipe == null) {
			Botania.LOGGER.warn("Missing apothecary recipe " + id);
		}
	}

	@Override
	public IVariable process(String key) {
		if (recipe == null) {
			return null;
		}
		switch (key) {
		case "recipe":
			return IVariable.wrap(recipe.method_8114().toString());
		case "output":
			return IVariable.from(recipe.method_8110());
		case "heading":
			return IVariable.from(recipe.method_8110().method_7964());
		}
		return null;
	}
}
