/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2572;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ManaInfusionProcessor implements IComponentProcessor {
	private List<IManaInfusionRecipe> recipes;
	private boolean hasCustomHeading;

	@Override
	public void setup(IVariableProvider variables) {
		if (variables.has("recipes") && variables.has("group")) {
			Botania.LOGGER.warn("Mana infusion template has both 'recipes' and 'group', ignoring 'recipes'");
		}

		ImmutableList.Builder<IManaInfusionRecipe> builder = ImmutableList.builder();
		if (variables.has("group")) {
			String group = variables.get("group").asString();
			TilePool.manaInfusionRecipes(class_310.method_1551().field_1687).stream()
					.filter(r -> r.method_8112().equals(group))
					.forEach(builder::add);
		} else {
			for (IVariable s : variables.get("recipes").asListOrSingleton()) {
				class_1860<?> recipe = ModRecipeTypes.getRecipes(class_310.method_1551().field_1687, ModRecipeTypes.MANA_INFUSION_TYPE).get(new class_2960(s.asString()));
				if (recipe instanceof IManaInfusionRecipe) {
					builder.add((IManaInfusionRecipe) recipe);
				} else {
					Botania.LOGGER.warn("Mana infusion template references nonexistent recipe {}", s);
				}
			}
		}

		this.recipes = builder.build();
		this.hasCustomHeading = variables.has("heading");
	}

	@Override
	public IVariable process(String key) {
		if (recipes.isEmpty()) {
			return null;
		}
		switch (key) {
		case "heading":
			if (!hasCustomHeading) {
				return IVariable.from(recipes.get(0).method_8110().method_7964());
			}
			return null;
		case "input":
			return PatchouliUtils.interweaveIngredients(recipes.stream().map(r -> r.method_8117().get(0)).collect(Collectors.toList()));
		case "output":
			return IVariable.wrapList(recipes.stream().map(IManaInfusionRecipe::method_8110).map(IVariable::from).collect(Collectors.toList()));
		case "catalyst":
			return IVariable.wrapList(recipes.stream().map(IManaInfusionRecipe::getCatalyst)
					.map(state -> {
						if (state == null) {
							return class_1799.field_8037;
						}
						return new class_1799(state.method_26204().method_8389());
					})
					.map(IVariable::from)
					.collect(Collectors.toList()));
		case "mana":
			return IVariable.wrapList(recipes.stream().mapToInt(IManaInfusionRecipe::getManaToConsume).mapToObj(IVariable::wrap).collect(Collectors.toList()));
		case "drop":
			class_2561 q = new class_2585("(?)").method_27692(class_124.field_1067);
			return IVariable.from(new class_2588("botaniamisc.drop").method_27693(" ").method_10852(q));
		case "dropTip0":
		case "dropTip1":
			class_2561 drop = new class_2572("key.drop").method_27692(class_124.field_1060);
			return IVariable.from(new class_2588("botaniamisc." + key, drop));
		}
		return null;
	}
}
