/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ElvenTradeProcessor implements IComponentProcessor {
	private List<IElvenTradeRecipe> recipes;
	private int longestIngredientSize, mostInputs, mostOutputs;

	@Override
	public void setup(IVariableProvider variables) {
		ImmutableList.Builder<IElvenTradeRecipe> builder = ImmutableList.builder();
		for (IVariable s : variables.get("recipes").asListOrSingleton()) {
			class_1860<?> recipe = ModRecipeTypes.getRecipes(class_310.method_1551().field_1687, ModRecipeTypes.ELVEN_TRADE_TYPE).get(new class_2960(s.asString()));
			if (recipe instanceof IElvenTradeRecipe) {
				builder.add((IElvenTradeRecipe) recipe);
			} else {
				Botania.LOGGER.warn("Missing elven trade recipe " + s);
			}
		}
		recipes = builder.build();
		for (IElvenTradeRecipe recipe : recipes) {
			List<class_1856> inputs = recipe.method_8117();
			for (class_1856 ingredient : inputs) {
				int length = ingredient.method_8105().length;
				if (length > longestIngredientSize) {
					longestIngredientSize = length;
				}
			}
			if (inputs.size() > mostInputs) {
				mostInputs = inputs.size();
			}
			if (recipe.getOutputs().size() > mostOutputs) {
				mostOutputs = recipe.getOutputs().size();
			}
		}
	}

	@Override
	public IVariable process(String key) {
		if (recipes.isEmpty()) {
			return null;
		}
		if (key.equals("heading")) {
			return IVariable.from(recipes.get(0).getOutputs().get(0).method_7964());
		} else if (key.startsWith("input")) {
			int index = Integer.parseInt(key.substring(5)) - 1;
			if (index < mostInputs) {
				return interweaveIngredients(index);
			} else {
				return null;
			}
		}
		if (key.startsWith("output")) {
			int index = Integer.parseInt(key.substring(6)) - 1;
			if (index < mostOutputs) {
				return IVariable.wrapList(recipes.stream().map(IElvenTradeRecipe::getOutputs)
						.map(l -> index < l.size() ? l.get(index) : class_1799.field_8037)
						.map(IVariable::from)
						.collect(Collectors.toList()));
			}
		}
		return null;
	}

	private IVariable interweaveIngredients(int inputIndex) {
		List<class_1856> recipes = this.recipes.stream().map(IElvenTradeRecipe::method_8117).map(ingredients -> {
			if (inputIndex < ingredients.size()) {
				return ingredients.get(inputIndex);
			} else {
				return class_1856.field_9017;
			}
		}).collect(Collectors.toList());
		return PatchouliUtils.interweaveIngredients(recipes, longestIngredientSize);
	}

}
