/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.patchouli.processor;

import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ModItems;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class BrewRecipeProcessor implements IComponentProcessor {
	private IBrewRecipe recipe;

	@Override
	public void setup(IVariableProvider variables) {
		class_2960 id = new class_2960(variables.get("recipe").asString());
		class_1860<?> recipe = ModRecipeTypes.getRecipes(class_310.method_1551().field_1687, ModRecipeTypes.BREW_TYPE).get(id);
		if (recipe instanceof IBrewRecipe) {
			this.recipe = (IBrewRecipe) recipe;
		} else {
			Botania.LOGGER.warn("Missing brew recipe " + id);
		}
	}

	@Override
	public IVariable process(String key) {
		if (recipe == null) {
			return null;
		} else if (key.equals("heading")) {
			return IVariable.from(new class_2588("botaniamisc.brewOf", new class_2588(recipe.getBrew().getTranslationKey())));
		} else if (key.equals("vial")) {
			return IVariable.from(recipe.getOutput(new class_1799(ModItems.vial)));
		} else if (key.equals("flask")) {
			return IVariable.from(recipe.getOutput(new class_1799(ModItems.flask)));
		} else if (key.startsWith("input")) {
			int requestedIndex = Integer.parseInt(key.substring(5)) - 1;
			int indexOffset = (6 - recipe.method_8117().size()) / 2; //Center the brew ingredients
			int index = requestedIndex - indexOffset;

			if (index < recipe.method_8117().size() && index >= 0) {
				return IVariable.wrapList(Arrays.stream(recipe.method_8117().get(index).method_8105()).map(IVariable::from).collect(Collectors.toList()));
			} else {
				return null;
			}
		} else if (key.equals("is_offset")) {
			return IVariable.wrap(recipe.method_8117().size() % 2 == 0);
		}
		return null;
	}
}
