/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.patchouli.component;

import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;

import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_437;
import net.minecraft.class_4587;

/**
 * Base custom Patchouli component that draws a rotating circle of items.
 * Size is 80x80. For a centered one, set X to -1.
 * For usage with a specified list of items, see {@link RotatingItemListComponent}.
 * For usage with a runic altar or petal apothecary recipes, see {@link RotatingRecipeComponent}.
 */
abstract class RotatingItemListComponentBase implements ICustomComponent {
	protected transient List<class_1856> ingredients;
	protected transient int x, y;

	@Override
	public void build(int componentX, int componentY, int pageNum) {
		this.x = componentX != -1 ? componentX : 17;
		this.y = componentY;
		this.ingredients = makeIngredients();
	}

	protected abstract List<class_1856> makeIngredients();

	@Override
	public void render(class_4587 ms, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
		int degreePerInput = (int) (360F / ingredients.size());
		int ticksElapsed = context.getTicksInBook();

		float currentDegree = ConfigHandler.CLIENT.lexiconRotatingItems.getValue()
				? class_437.method_25442()
						? ticksElapsed
						: ticksElapsed + pticks
				: 0;

		for (class_1856 input : ingredients) {
			renderIngredientAtAngle(ms, context, currentDegree, input, mouseX, mouseY);

			currentDegree += degreePerInput;
		}
	}

	private void renderIngredientAtAngle(class_4587 ms, IComponentRenderContext context, float angle, class_1856 ingredient, int mouseX, int mouseY) {
		if (ingredient.method_8103()) {
			return;
		}

		angle -= 90;
		int radius = 32;
		double xPos = x + Math.cos(angle * Math.PI / 180D) * radius + 32;
		double yPos = y + Math.sin(angle * Math.PI / 180D) * radius + 32;

		ms.method_22903(); // This translation makes it not stuttery. It does not affect the tooltip as that is drawn separately later.
		ms.method_22904(xPos - (int) xPos, yPos - (int) yPos, 0);
		context.renderIngredient(ms, (int) xPos, (int) yPos, mouseX, mouseY, ingredient);
		ms.method_22909();
	}

}
