/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model.armor;

import net.minecraft.class_1304;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class ModelArmorTerrasteel extends ModelArmor {

	private final class_630 helmAnchor;
	private final class_630 helm;
	private final class_630 helmFront;
	private final class_630 helmLeaf1l;
	private final class_630 helmLeaf2l;
	private final class_630 helmLeaf3l;
	private final class_630 helmLeaf1r;
	private final class_630 helmLeaf2r;
	private final class_630 helmLeaf3r;
	private final class_630 helmbranch1l;
	private final class_630 helmbranch2l;
	private final class_630 helmbranch1r;
	private final class_630 helmbranch2r;

	private final class_630 bodyAnchor;
	private final class_630 bodyTop;
	private final class_630 bodyBottom;

	private final class_630 armLAnchor;
	private final class_630 armL;
	private final class_630 armLpauldron;
	private final class_630 armLbranch1;
	private final class_630 armLbranch2;

	private final class_630 armRAnchor;
	private final class_630 armR;
	private final class_630 armRpauldron;
	private final class_630 armRbranch1;
	private final class_630 armRbranch2;

	private final class_630 pantsAnchor;
	private final class_630 belt;
	private final class_630 legL;
	private final class_630 legR;

	private final class_630 bootL;
	private final class_630 bootLtop;
	private final class_630 bootLbranch1;
	private final class_630 bootLbranch2;

	private final class_630 bootR;
	private final class_630 bootRtop;
	private final class_630 bootRbranch1;
	private final class_630 bootRbranch2;

	public ModelArmorTerrasteel(class_1304 slot) {
		super(slot);

		field_17138 = 64;
		field_17139 = 128;
		float s = 0.01F;

		//helm
		this.helmAnchor = new class_630(this, 0, 0);
		this.helmAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.helmAnchor.method_2856(-1.0F, -2.0F, 0.0F, 2, 2, 2, s);
		this.helm = new class_630(this, 0, 0);
		this.helm.method_2851(0.0F, 0.0F, 0.0F);
		this.helm.method_2856(-4.5F, -9.0F, -4.5F, 9, 11, 9, s);
		this.helmFront = new class_630(this, 36, 0);
		this.helmFront.method_2851(0.0F, 0.0F, 0.0F);
		this.helmFront.method_2856(-1.5F, -10.0F, -5.5F, 3, 8, 7, s);
		this.helmLeaf1l = new class_630(this, 56, 14);
		this.helmLeaf1l.field_3666 = true;
		this.helmLeaf1l.method_2851(4.5F, -6.0F, -2.5F);
		this.helmLeaf1l.method_2856(0.0F, -3.0F, -1.0F, 2, 3, 1, s);
		this.setRotateAngle(helmLeaf1l, -0.2617993877991494F, -0.2617993877991494F, 0.5235987755982988F);
		this.helmLeaf2l = new class_630(this, 56, 8);
		this.helmLeaf2l.field_3666 = true;
		this.helmLeaf2l.method_2851(4.5F, -6.0F, -0.5F);
		this.helmLeaf2l.method_2856(0.0F, -5.0F, -1.0F, 2, 5, 1, s);
		this.setRotateAngle(helmLeaf2l, -0.5235987755982988F, -0.5235987755982988F, 0.7853981633974483F);
		this.helmLeaf3l = new class_630(this, 56, 0);
		this.helmLeaf3l.field_3666 = true;
		this.helmLeaf3l.method_2851(4.5F, -6.0F, 2.5F);
		this.helmLeaf3l.method_2856(0.0F, -7.0F, -1.0F, 2, 7, 1, s);
		this.setRotateAngle(helmLeaf3l, -0.7853981633974483F, -0.7853981633974483F, 0.7853981633974483F);
		this.helmLeaf1r = new class_630(this, 56, 14);
		this.helmLeaf1r.method_2851(-4.5F, -6.0F, -2.5F);
		this.helmLeaf1r.method_2856(-2.0F, -3.0F, -1.0F, 2, 3, 1, s);
		this.setRotateAngle(helmLeaf1r, -0.2617993877991494F, 0.2617993877991494F, -0.5235987755982988F);
		this.helmLeaf2r = new class_630(this, 56, 8);
		this.helmLeaf2r.method_2851(-4.5F, -6.0F, -0.5F);
		this.helmLeaf2r.method_2856(-2.0F, -5.0F, -1.0F, 2, 5, 1, s);
		this.setRotateAngle(helmLeaf2r, -0.5235987755982988F, 0.5235987755982988F, -0.7853981633974483F);
		this.helmLeaf3r = new class_630(this, 56, 0);
		this.helmLeaf3r.method_2851(-4.5F, -6.0F, 2.5F);
		this.helmLeaf3r.method_2856(-2.0F, -7.0F, -1.0F, 2, 7, 1, s);
		this.setRotateAngle(helmLeaf3r, -0.7853981633974483F, 0.7853981633974483F, -0.7853981633974483F);
		this.helmbranch1l = new class_630(this, 36, 15);
		this.helmbranch1l.field_3666 = true;
		this.helmbranch1l.method_2851(2.5F, -9.0F, -3.5F);
		this.helmbranch1l.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 7, s);
		this.setRotateAngle(helmbranch1l, 0.5235987755982988F, 0.2617993877991494F, 0.0F);
		this.helmbranch2l = new class_630(this, 36, 15);
		this.helmbranch2l.field_3666 = true;
		this.helmbranch2l.method_2851(4.5F, -3.0F, -2.5F);
		this.helmbranch2l.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 7, s);
		this.setRotateAngle(helmbranch2l, 0.08726646259971647F, 0.2617993877991494F, 0.0F);
		this.helmbranch1r = new class_630(this, 36, 15);
		this.helmbranch1r.method_2851(-2.5F, -9.0F, -3.5F);
		this.helmbranch1r.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 7, s);
		this.setRotateAngle(helmbranch1r, 0.5235987755982988F, -0.2617993877991494F, 0.0F);
		this.helmbranch2r = new class_630(this, 36, 15);
		this.helmbranch2r.method_2851(-4.5F, -3.0F, -2.5F);
		this.helmbranch2r.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 7, s);
		this.setRotateAngle(helmbranch2r, 0.08726646259971647F, -0.2617993877991494F, 0.0F);

		//body
		this.bodyAnchor = new class_630(this, 0, 0);
		this.bodyAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyAnchor.method_2856(-1.0F, 0.0F, -1.0F, 2, 2, 2, s);
		this.bodyTop = new class_630(this, 0, 20);
		this.bodyTop.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyTop.method_2856(-5.5F, 0.0F, -3.0F, 11, 6, 6, s);
		this.bodyBottom = new class_630(this, 0, 32);
		this.bodyBottom.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyBottom.method_2856(-4.5F, 5.0F, -2.5F, 9, 3, 5, s);

		//armL
		this.armLAnchor = new class_630(this, 0, 0);
		this.armLAnchor.field_3666 = true;
		this.armLAnchor.method_2851(4.0F, 2.0F, 0.0F);
		this.armLAnchor.method_2856(0.0F, -1.0F, -1.0F, 2, 2, 2, s);
		this.armL = new class_630(this, 0, 52);
		this.armL.field_3666 = true;
		this.armL.method_2851(0.0F, 0.0F, 0.0F);
		this.armL.method_2856(-1.5F, 3.0F, -2.49F, 5, 8, 5, s);
		this.armLpauldron = new class_630(this, 0, 40);
		this.armLpauldron.field_3666 = true;
		this.armLpauldron.method_2851(1.5F, 0.0F, 0.0F);
		this.armLpauldron.method_2856(-1.0F, -3.0F, -3.0F, 6, 6, 6, s);
		this.armLbranch1 = new class_630(this, 36, 15);
		this.armLbranch1.field_3666 = true;
		this.armLbranch1.method_2851(4.0F, -3.0F, -1.0F);
		this.armLbranch1.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 7, s);
		this.setRotateAngle(armLbranch1, 0.5235987755982988F, 0.5235987755982988F, 0.0F);
		this.armLbranch2 = new class_630(this, 36, 24);
		this.armLbranch2.field_3666 = true;
		this.armLbranch2.method_2851(5.0F, -2.0F, 0.0F);
		this.armLbranch2.method_2856(-1.0F, 0.0F, 0.0F, 2, 2, 5, s);
		this.setRotateAngle(armLbranch2, 0.08726646259971647F, 0.7853981633974483F, 0.0F);

		//armR
		this.armRAnchor = new class_630(this, 0, 0);
		this.armRAnchor.field_3666 = true;
		this.armRAnchor.method_2851(-4.0F, 2.0F, 0.0F);
		this.armRAnchor.method_2856(-2.0F, -1.0F, -1.0F, 2, 2, 2, s);
		this.armR = new class_630(this, 0, 52);
		this.armR.method_2851(0.0F, 0.0F, 0.0F);
		this.armR.method_2856(-3.5F, 3.0F, -2.51F, 5, 8, 5, s);
		this.armRpauldron = new class_630(this, 0, 40);
		this.armRpauldron.method_2851(-1.5F, 0.0F, 0.0F);
		this.armRpauldron.method_2856(-5.0F, -3.0F, -3.0F, 6, 6, 6, s);
		this.armRbranch1 = new class_630(this, 36, 15);
		this.armRbranch1.method_2851(-4.0F, -3.0F, -1.0F);
		this.armRbranch1.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 7, s);
		this.setRotateAngle(armRbranch1, 0.5235987755982988F, -0.5235987755982988F, 0.0F);
		this.armRbranch2 = new class_630(this, 36, 24);
		this.armRbranch2.method_2851(-5.0F, -2.0F, 0.0F);
		this.armRbranch2.method_2856(-1.0F, 0.0F, 0.0F, 2, 2, 5, s);
		this.setRotateAngle(armRbranch2, 0.08726646259971647F, -0.7853981633974483F, 0.0F);

		//pants
		this.pantsAnchor = new class_630(this, 0, 0);
		this.pantsAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.pantsAnchor.method_2856(-1.0F, 0.0F, -1.0F, 2, 2, 2, s);
		this.belt = new class_630(this, 0, 65);
		this.belt.method_2851(0.0F, 0.0F, 0.0F);
		this.belt.method_2856(-4.5F, 8.0F, -3.0F, 9, 5, 6, s);
		this.legL = new class_630(this, 0, 76);
		this.legL.field_3666 = true;
		this.legL.method_2851(1.9F, 12.0F, 0.0F);
		this.legL.method_2856(-2.39F, -0.01F, -2.49F, 5, 6, 5, s);
		this.legR = new class_630(this, 0, 76);
		this.legR.method_2851(-1.9F, 12.0F, 0.0F);
		this.legR.method_2856(-2.61F, -0.01F, -2.51F, 5, 6, 5, s);

		//boots
		this.bootL = new class_630(this, 0, 94);
		this.bootL.field_3666 = true;
		this.bootL.method_2851(1.9F, 12.0F, 0.0F);
		this.bootL.method_2856(-2.39F, 8.5F, -2.49F, 5, 4, 5, s);
		this.bootLtop = new class_630(this, 0, 87);
		this.bootLtop.field_3666 = true;
		this.bootLtop.method_2851(0.0F, 0.0F, 0.0F);
		this.bootLtop.method_2856(-2.39F, 6.0F, -2.49F, 6, 2, 5, s);
		this.bootLbranch1 = new class_630(this, 36, 15);
		this.bootLbranch1.field_3666 = true;
		this.bootLbranch1.method_2851(3.5F, 6.0F, 0.0F);
		this.bootLbranch1.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 7, s);
		this.setRotateAngle(bootLbranch1, 0.2617993877991494F, 0.2617993877991494F, -0.08726646259971647F);
		this.bootLbranch2 = new class_630(this, 36, 24);
		this.bootLbranch2.field_3666 = true;
		this.bootLbranch2.method_2851(2.5F, 9.0F, 0.0F);
		this.bootLbranch2.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 5, s);
		this.setRotateAngle(bootLbranch2, 0.08726646259971647F, 0.7853981633974483F, 0.0F);
		this.bootR = new class_630(this, 0, 94);
		this.bootR.method_2851(-1.9F, 12.0F, 0.0F);
		this.bootR.method_2856(-2.61F, 8.5F, -2.51F, 5, 4, 5, s);
		this.bootRtop = new class_630(this, 0, 87);
		this.bootRtop.method_2851(0.0F, 0.0F, 0.0F);
		this.bootRtop.method_2856(-3.61F, 6.0F, -2.51F, 6, 2, 5, s);
		this.bootRbranch1 = new class_630(this, 36, 15);
		this.bootRbranch1.method_2851(-3.5F, 6.0F, 0.0F);
		this.bootRbranch1.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 7, s);
		this.setRotateAngle(bootRbranch1, 0.2617993877991494F, -0.2617993877991494F, 0.08726646259971647F);
		this.bootRbranch2 = new class_630(this, 36, 24);
		this.bootRbranch2.method_2851(-2.5F, 9.0F, 0.5F);
		this.bootRbranch2.method_2856(-1.0F, -1.0F, 0.0F, 2, 2, 5, s);
		this.setRotateAngle(bootRbranch2, 0.08726646259971647F, -0.7853981633974483F, 0.0F);

		//hierarchy
		this.helmAnchor.method_2845(this.helm);
		this.helm.method_2845(this.helmFront);
		this.helm.method_2845(this.helmLeaf1l);
		this.helm.method_2845(this.helmLeaf2l);
		this.helm.method_2845(this.helmLeaf3l);
		this.helm.method_2845(this.helmLeaf1r);
		this.helm.method_2845(this.helmLeaf2r);
		this.helm.method_2845(this.helmLeaf3r);
		this.helm.method_2845(this.helmbranch1l);
		this.helm.method_2845(this.helmbranch2l);
		this.helm.method_2845(this.helmbranch1r);
		this.helm.method_2845(this.helmbranch2r);

		this.bodyAnchor.method_2845(this.bodyTop);
		this.bodyTop.method_2845(this.bodyBottom);
		this.armLAnchor.method_2845(this.armL);
		this.armL.method_2845(this.armLpauldron);
		this.armLpauldron.method_2845(this.armLbranch1);
		this.armLpauldron.method_2845(this.armLbranch2);
		this.armRAnchor.method_2845(this.armR);
		this.armR.method_2845(this.armRpauldron);
		this.armRpauldron.method_2845(this.armRbranch1);
		this.armRpauldron.method_2845(this.armRbranch2);

		this.pantsAnchor.method_2845(this.belt);

		this.bootL.method_2845(bootLtop);
		this.bootLtop.method_2845(bootLbranch1);
		this.bootLtop.method_2845(bootLbranch2);
		this.bootR.method_2845(bootRtop);
		this.bootRtop.method_2845(bootRbranch1);
		this.bootRtop.method_2845(bootRbranch2);
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a) {

		helmAnchor.field_3665 = slot == class_1304.field_6169;
		bodyAnchor.field_3665 = slot == class_1304.field_6174;
		armLAnchor.field_3665 = slot == class_1304.field_6174;
		armRAnchor.field_3665 = slot == class_1304.field_6174;
		legR.field_3665 = slot == class_1304.field_6172;
		legL.field_3665 = slot == class_1304.field_6172;
		bootL.field_3665 = slot == class_1304.field_6166;
		bootR.field_3665 = slot == class_1304.field_6166;

		field_3394.field_3665 = false;

		field_3398 = helmAnchor;
		field_3391 = bodyAnchor;
		field_3401 = armRAnchor;
		field_3390 = armLAnchor;
		if (slot == class_1304.field_6172) {
			field_3391 = pantsAnchor;
			field_3392 = legR;
			field_3397 = legL;
		} else {
			field_3392 = bootR;
			field_3397 = bootL;
		}

		super.method_2828(ms, buffer, light, overlay, r, g, b, a);
	}
}
