/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model.armor;

import net.minecraft.class_1304;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class ModelArmorManaweave extends ModelArmor {

	private final class_630 helmAnchor;
	private final class_630 helm;

	private final class_630 bodyAnchor;
	private final class_630 bodyTop;
	private final class_630 bodyBottom;

	private final class_630 armLAnchor;
	private final class_630 armL;
	private final class_630 armLpauldron;
	private final class_630 armRAnchor;
	private final class_630 armR;
	private final class_630 armRpauldron;

	private final class_630 pantsAnchor;
	private final class_630 legL;
	private final class_630 skirtL;
	private final class_630 legR;
	private final class_630 skirtR;

	private final class_630 bootL;
	private final class_630 bootR;

	public ModelArmorManaweave(class_1304 slot) {
		super(slot);

		field_17138 = 64;
		field_17139 = 128;
		float s = 0.01F;

		//helm
		this.helmAnchor = new class_630(this, 0, 0);
		this.helmAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.helmAnchor.method_2856(-1.0F, -2.0F, 0.0F, 2, 2, 2, s);
		this.helm = new class_630(this, 0, 0);
		this.helm.method_2851(0.0F, 0.0F, 0.0F);
		this.helm.method_2856(-4.5F, -9.5F, -4.0F, 9, 11, 10, s);
		this.setRotateAngle(helm, 0.17453292519943295F, 0.0F, 0.0F);

		//body
		this.bodyAnchor = new class_630(this, 0, 0);
		this.bodyAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyAnchor.method_2856(-1.0F, 0.0F, -1.0F, 2, 2, 2, s);
		this.bodyTop = new class_630(this, 0, 21);
		this.bodyTop.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyTop.method_2856(-4.5F, -0.5F, -3.0F, 9, 7, 6, s);
		this.setRotateAngle(bodyTop, 0.0F, 0.0F, 0.0F);
		this.bodyBottom = new class_630(this, 0, 34);
		this.bodyBottom.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyBottom.method_2856(-4.5F, 6.5F, -2.5F, 9, 5, 5, s);
		this.setRotateAngle(bodyBottom, -0F, 0.0F, 0.0F);

		//armL
		this.armLAnchor = new class_630(this, 0, 0);
		this.armLAnchor.field_3666 = true;
		this.armLAnchor.method_2851(4.0F, 2.0F, 0.0F);
		this.armLAnchor.method_2856(0.0F, -1.0F, -1.0F, 2, 2, 2, s);
		this.armL = new class_630(this, 0, 44);
		this.armL.field_3666 = true;
		this.armL.method_2851(0.0F, 0.0F, 0.0F);
		this.armL.method_2856(-1.5F, -2.5F, -2.49F, 5, 10, 5, s);
		this.armLpauldron = new class_630(this, 20, 44);
		this.armLpauldron.field_3666 = true;
		this.armLpauldron.method_2851(0.0F, 0.0F, 0.0F);
		this.armLpauldron.method_2856(-1.0F, -3.0F, -3.0F, 6, 5, 6, s);
		this.setRotateAngle(armLpauldron, 0.0F, 0.0F, -0.08726646259971647F);

		//armR
		this.armRAnchor = new class_630(this, 0, 0);
		this.armRAnchor.field_3666 = true;
		this.armRAnchor.method_2851(-4.0F, 2.0F, 0.0F);
		this.armRAnchor.method_2856(-2.0F, -1.0F, -1.0F, 2, 2, 2, s);
		this.armR = new class_630(this, 0, 44);
		this.armR.method_2851(0.0F, 0.0F, 0.0F);
		this.armR.method_2856(-3.5F, -2.5F, -2.51F, 5, 10, 5, s);
		this.armRpauldron = new class_630(this, 20, 44);
		this.armRpauldron.method_2851(0.0F, 0.0F, 0.0F);
		this.armRpauldron.method_2856(-5.0F, -3.0F, -3.0F, 6, 5, 6, s);
		this.setRotateAngle(armRpauldron, 0.0F, 0.0F, 0.08726646259971647F);

		//pants
		this.pantsAnchor = new class_630(this, 0, 0);
		this.pantsAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.pantsAnchor.method_2856(-1.0F, 0.0F, -1.0F, 2, 2, 2, s);
		this.legL = new class_630(this, 0, 78);
		this.legL.field_3666 = true;
		this.legL.method_2851(1.9F, 12.0F, 0.0F);
		this.legL.method_2856(-2.39F, -0.5F, -2.49F, 5, 6, 5, s);
		this.skirtL = new class_630(this, 0, 59);
		this.skirtL.field_3666 = true;
		this.skirtL.method_2851(-0.5F, -2.0F, -2.5F);
		this.skirtL.method_2856(-1.0F, 0.0F, -0.5F, 5, 13, 6, s);
		this.setRotateAngle(skirtL, 0.0F, -0.17453292519943295F, -0.2617993877991494F);
		this.legR = new class_630(this, 0, 78);
		this.legR.method_2851(-1.9F, 12.0F, 0.0F);
		this.legR.method_2856(-2.61F, 0.0F, -2.51F, 5, 6, 5, s);
		this.skirtR = new class_630(this, 0, 59);
		this.skirtR.method_2851(0.5F, -2.0F, -2.5F);
		this.skirtR.method_2856(-4.0F, 0.0F, -0.5F, 5, 13, 6, s);
		this.setRotateAngle(skirtR, 0.0F, 0.17453292519943295F, 0.2617993877991494F);

		//boot
		this.bootL = new class_630(this, 0, 89);
		this.bootL.field_3666 = true;
		this.bootL.method_2851(1.9F, 12.0F, 0.0F);
		this.bootL.method_2856(-2.39F, 8.5F, -2.49F, 5, 4, 5, s);
		this.bootR = new class_630(this, 0, 89);
		this.bootR.method_2851(-1.9F, 12.0F, 0.0F);
		this.bootR.method_2856(-2.61F, 8.5F, -2.51F, 5, 4, 5, s);

		//hierarchy
		this.helmAnchor.method_2845(this.helm);

		this.bodyAnchor.method_2845(this.bodyTop);
		this.bodyTop.method_2845(this.bodyBottom);

		this.armLAnchor.method_2845(this.armL);
		this.armL.method_2845(this.armLpauldron);

		this.armRAnchor.method_2845(this.armR);
		this.armR.method_2845(this.armRpauldron);

		this.legL.method_2845(this.skirtL);
		this.legR.method_2845(this.skirtR);
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a) {

		helmAnchor.field_3665 = slot == class_1304.field_6169;
		bodyAnchor.field_3665 = slot == class_1304.field_6174;
		armRAnchor.field_3665 = slot == class_1304.field_6174;
		armLAnchor.field_3665 = slot == class_1304.field_6174;
		legR.field_3665 = slot == class_1304.field_6172;
		legL.field_3665 = slot == class_1304.field_6172;
		bootL.field_3665 = slot == class_1304.field_6166;
		bootR.field_3665 = slot == class_1304.field_6166;
		field_3394.field_3665 = false;

		field_3398 = helmAnchor;
		field_3391 = bodyAnchor;
		field_3401 = armRAnchor;
		field_3390 = armLAnchor;
		if (slot == class_1304.field_6172) {
			field_3392 = legR;
			field_3397 = legL;
		} else {
			field_3392 = bootR;
			field_3397 = bootL;
		}

		super.method_2828(ms, buffer, light, overlay, r, g, b, a);
	}
}
