/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model.armor;

import net.minecraft.class_1304;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class ModelArmorManasteel extends ModelArmor {

	private final class_630 helmAnchor;
	private final class_630 helm;
	private final class_630 helmTop;
	private final class_630 helmCrystal;

	private final class_630 bodyAnchor;
	private final class_630 bodyTop;
	private final class_630 bodyBottom;

	private final class_630 armLAnchor;
	private final class_630 armL;
	private final class_630 armLpauldron;
	private final class_630 armLcrystal;

	private final class_630 armRAnchor;
	private final class_630 armR;
	private final class_630 armRpauldron;
	private final class_630 armRcrystal;
	private final class_630 pantsAnchor;
	private final class_630 belt;
	private final class_630 legL;
	private final class_630 legR;

	private final class_630 bootL;
	private final class_630 bootLcrystal;
	private final class_630 bootR;
	private final class_630 bootRcrystal;

	public ModelArmorManasteel(class_1304 slot) {
		super(slot);

		this.field_17138 = 64;
		this.field_17139 = 128;
		float s = 0.01F;

		//helm
		this.helmAnchor = new class_630(this, 0, 0);
		this.helmAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.helmAnchor.method_2856(-1.0F, -2.0F, 0.0F, 2, 2, 2, s);
		this.helm = new class_630(this, 0, 0);
		this.helm.method_2851(0.0F, 0.0F, 0.0F);
		this.helm.method_2856(-4.5F, -8.5F, -4.5F, 9, 9, 9, s);
		this.helmTop = new class_630(this, 36, 6);
		this.helmTop.method_2851(0.0F, -8.5F, 3.5F);
		this.helmTop.method_2856(-1.5F, 0.0F, -7.0F, 3, 3, 7, s);
		this.setRotateAngle(helmTop, -0.2617993877991494F, 0.0F, 0.0F);
		this.helmCrystal = new class_630(this, 36, 0);
		this.helmCrystal.method_2851(0.0F, -7.5F, -4.5F);
		this.helmCrystal.method_2856(-1.5F, -4.0F, -1.0F, 3, 5, 1, s);
		this.setRotateAngle(helmCrystal, 0.08726646259971647F, 0.0F, 0.0F);

		//body
		this.bodyAnchor = new class_630(this, 0, 0);
		this.bodyAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyAnchor.method_2856(-1.0F, 0.0F, -1.0F, 2, 2, 2, s);
		this.bodyTop = new class_630(this, 0, 18);
		this.bodyTop.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyTop.method_2856(-4.5F, -0.5F, -3.0F, 9, 6, 6, s);
		this.setRotateAngle(bodyTop, 0.0F, 0.0F, 0.0F);
		this.bodyBottom = new class_630(this, 0, 30);
		this.bodyBottom.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyBottom.method_2856(-2.5F, 5.5F, -2.5F, 5, 3, 5, 0.0F);

		//armL
		this.armLAnchor = new class_630(this, 0, 0);
		this.armLAnchor.field_3666 = true;
		this.armLAnchor.method_2851(4.0F, 2.0F, 0.0F);
		this.armLAnchor.method_2856(0.0F, -1.0F, -1.0F, 2, 2, 2, s);
		this.armL = new class_630(this, 22, 40);
		this.armL.field_3666 = true;
		this.armL.method_2851(0.0F, 0.0F, 0.0F);
		this.armL.method_2856(1.5F, 2.0F, -2.49F, 2, 6, 5, s);
		this.armLpauldron = new class_630(this, 0, 40);
		this.armLpauldron.field_3666 = true;
		this.armLpauldron.method_2851(0.0F, 0.0F, 0.0F);
		this.armLpauldron.method_2856(-0.5F, -3.0F, -3.0F, 5, 4, 6, s);
		this.armLcrystal = new class_630(this, 36, 40);
		this.armLcrystal.field_3666 = true;
		this.armLcrystal.method_2851(2.0F, -2.5F, 0.0F);
		this.armLcrystal.method_2856(-0.5F, -2.5F, -1.5F, 2, 3, 3, s);
		this.setRotateAngle(armLcrystal, 0.0F, 0.0F, -0.08726646259971647F);

		//armR
		this.armRAnchor = new class_630(this, 0, 0);
		this.armRAnchor.field_3666 = true;
		this.armRAnchor.method_2851(-4.0F, 2.0F, 0.0F);
		this.armRAnchor.method_2856(-2.0F, -1.0F, -1.0F, 2, 2, 2, s);
		this.armR = new class_630(this, 22, 40);
		this.armR.method_2851(0.0F, 0.0F, 0.0F);
		this.armR.method_2856(-3.5F, 2.0F, -2.51F, 2, 6, 5, s);
		this.armRpauldron = new class_630(this, 0, 40);
		this.armRpauldron.method_2851(0.0F, 0.0F, 0.0F);
		this.armRpauldron.method_2856(-4.5F, -3.0F, -3.0F, 5, 4, 6, s);
		this.armRcrystal = new class_630(this, 36, 40);
		this.armRcrystal.method_2851(-2.0F, -2.5F, 0.0F);
		this.armRcrystal.method_2856(-1.5F, -2.5F, -1.5F, 2, 3, 3, s);
		this.setRotateAngle(armRcrystal, 0.0F, 0.0F, 0.08726646259971647F);

		//pants
		this.pantsAnchor = new class_630(this, 0, 0);
		this.pantsAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.pantsAnchor.method_2856(-1.0F, 0.0F, -1.0F, 2, 2, 2, s);
		this.belt = new class_630(this, 0, 51);
		this.belt.method_2851(0.0F, 0.0F, 0.0F);
		this.belt.method_2856(-4.5F, 9.0F, -3.0F, 9, 3, 6, s);
		this.legL = new class_630(this, 0, 60);
		this.legL.field_3666 = true;
		this.legL.method_2851(1.9F, 12.0F, 0.0F);
		this.legL.method_2856(-0.39F, 0.0F, -2.49F, 3, 6, 5, s);
		this.legR = new class_630(this, 0, 60);
		this.legR.method_2851(-1.9F, 12.0F, 0.0F);
		this.legR.method_2856(-2.61F, 0.0F, -2.51F, 3, 6, 5, s);

		//boots
		this.bootL = new class_630(this, 0, 71);
		this.bootL.field_3666 = true;
		this.bootL.method_2851(1.9F, 12.0F, 0.0F);
		this.bootL.method_2856(-2.39F, 8.5F, -2.49F, 5, 4, 5, s);
		this.bootLcrystal = new class_630(this, 36, 46);
		this.bootLcrystal.field_3666 = true;
		this.bootLcrystal.method_2851(2.5F, 9.0F, 2.0F);
		this.bootLcrystal.method_2856(-1.0F, -2.0F, -1.5F, 2, 3, 3, s);
		this.setRotateAngle(bootLcrystal, 0.0F, 0.0F, 0.08726646259971647F);
		this.bootR = new class_630(this, 0, 71);
		this.bootR.method_2851(-2.0F, 12.0F, 0.0F);
		this.bootR.method_2856(-2.5F, 8.5F, -2.51F, 5, 4, 5, s);
		this.bootRcrystal = new class_630(this, 36, 46);
		this.bootRcrystal.method_2851(-2.5F, 9.0F, 2.0F);
		this.bootRcrystal.method_2856(-1.0F, -2.0F, -1.5F, 2, 3, 3, s);
		this.setRotateAngle(bootRcrystal, 0.0F, 0.0F, -0.08726646259971647F);

		//hierarchy
		this.helmAnchor.method_2845(this.helm);
		this.helm.method_2845(this.helmTop);
		this.helm.method_2845(this.helmCrystal);

		this.bodyAnchor.method_2845(this.bodyTop);
		this.bodyTop.method_2845(this.bodyBottom);
		this.armLAnchor.method_2845(this.armL);
		this.armL.method_2845(this.armLpauldron);
		this.armLpauldron.method_2845(this.armLcrystal);
		this.armRAnchor.method_2845(this.armR);
		this.armR.method_2845(this.armRpauldron);
		this.armRpauldron.method_2845(this.armRcrystal);

		this.pantsAnchor.method_2845(this.belt);

		this.bootL.method_2845(bootLcrystal);
		this.bootR.method_2845(bootRcrystal);
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a) {

		helmAnchor.field_3665 = slot == class_1304.field_6169;
		bodyAnchor.field_3665 = slot == class_1304.field_6174;
		armRAnchor.field_3665 = slot == class_1304.field_6174;
		armLAnchor.field_3665 = slot == class_1304.field_6174;
		legR.field_3665 = slot == class_1304.field_6172;
		legL.field_3665 = slot == class_1304.field_6172;
		bootL.field_3665 = slot == class_1304.field_6166;
		bootR.field_3665 = slot == class_1304.field_6166;
		field_3394.field_3665 = false;

		field_3398 = helmAnchor;
		field_3391 = bodyAnchor;
		field_3401 = armRAnchor;
		field_3390 = armLAnchor;
		if (slot == class_1304.field_6172) {
			field_3391 = pantsAnchor;
			field_3392 = legR;
			field_3397 = legL;
		} else {
			field_3392 = bootR;
			field_3397 = bootL;
		}

		super.method_2828(ms, buffer, light, overlay, r, g, b, a);
	}
}
