/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model.armor;

import net.minecraft.class_1304;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class ModelArmorElementium extends ModelArmor {

	private final class_630 helmAnchor;
	private final class_630 helm;
	private final class_630 helmFairy;
	private final class_630 helmWing1r;
	private final class_630 helmWing2l;
	private final class_630 helmWing1l;
	private final class_630 helmWing2r;

	private final class_630 bodyAnchor;
	private final class_630 bodyTop;
	private final class_630 bodyBottom;

	private final class_630 armLAnchor;
	private final class_630 armL;
	private final class_630 armLpauldron;
	private final class_630 armLwing1;
	private final class_630 armLwing2;

	private final class_630 armRAnchor;
	private final class_630 armR;
	private final class_630 armRpauldron;
	private final class_630 armRwing1;
	private final class_630 armRwing2;

	private final class_630 pantsAnchor;
	private final class_630 belt;
	private final class_630 legL;
	private final class_630 legR;

	private final class_630 bootL;
	private final class_630 bootLwing1;
	private final class_630 bootLwing2;
	private final class_630 bootR;
	private final class_630 bootRwing1;
	private final class_630 bootRwing2;

	public ModelArmorElementium(class_1304 slot) {
		super(slot);

		this.field_17138 = 64;
		this.field_17139 = 128;
		float s = 0.01F;

		//helm
		this.helmAnchor = new class_630(this, 0, 0);
		this.helmAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.helmAnchor.method_2856(-1.0F, -2.0F, 0.0F, 2, 2, 2, s);
		this.helm = new class_630(this, 0, 0);
		this.helm.method_2851(0.0F, 0.0F, 0.0F);
		this.helm.method_2856(-4.5F, -9.0F, -4.5F, 9, 9, 9, s);
		this.helmFairy = new class_630(this, 36, 11);
		this.helmFairy.method_2851(0.0F, 0.0F, 0.0F);
		this.helmFairy.method_2856(-2.5F, -10.0F, -5.5F, 5, 5, 5, s);
		this.helmWing1l = new class_630(this, 36, 0);
		this.helmWing1l.field_3666 = true;
		this.helmWing1l.method_2851(4.5F, -6.0F, -0.5F);
		this.helmWing1l.method_2856(-1.0F, -5.0F, 0.0F, 1, 5, 6, s);
		this.setRotateAngle(helmWing1l, 0.2617993877991494F, 0.5235987755982988F, 0.2617993877991494F);
		this.helmWing2l = new class_630(this, 50, 0);
		this.helmWing2l.method_2851(4.5F, -6.0F, -0.5F);
		this.helmWing2l.method_2856(-1.0F, 0.0F, 0.0F, 1, 3, 4, s);
		this.setRotateAngle(helmWing2l, -0.2617993877991494F, 0.2617993877991494F, -0.2617993877991494F);
		this.helmWing1r = new class_630(this, 36, 0);
		this.helmWing1r.method_2851(-4.5F, -6.0F, -0.5F);
		this.helmWing1r.method_2856(0.0F, -5.0F, 0.0F, 1, 5, 6, s);
		this.setRotateAngle(helmWing1r, 0.2617993877991494F, -0.5235987755982988F, -0.2617993877991494F);
		this.helmWing2r = new class_630(this, 50, 0);
		this.helmWing2r.field_3666 = true;
		this.helmWing2r.method_2851(-4.5F, -6.0F, -0.5F);
		this.helmWing2r.method_2856(0.0F, 0.0F, 0.0F, 1, 3, 4, s);
		this.setRotateAngle(helmWing2r, -0.2617993877991494F, -0.2617993877991494F, 0.2617993877991494F);

		//body
		this.bodyAnchor = new class_630(this, 0, 0);
		this.bodyAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyAnchor.method_2856(-1.0F, 0.0F, -1.0F, 2, 2, 2, s);
		this.bodyTop = new class_630(this, 0, 19);
		this.bodyTop.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyTop.method_2856(-4.5F, 0.0F, -3.0F, 9, 6, 6, s);
		this.bodyBottom = new class_630(this, 0, 31);
		this.bodyBottom.method_2851(0.0F, 0.0F, 0.0F);
		this.bodyBottom.method_2856(-3.5F, 5.0F, -2.5F, 7, 3, 5, s);

		//armL
		this.armLAnchor = new class_630(this, 0, 0);
		this.armLAnchor.field_3666 = true;
		this.armLAnchor.method_2851(4.0F, 2.0F, 0.0F);
		this.armLAnchor.method_2856(0.0F, -1.0F, -1.0F, 2, 2, 2, s);
		this.armL = new class_630(this, 24, 40);
		this.armL.field_3666 = true;
		this.armL.method_2851(0.0F, 0.0F, -0.0F);
		this.armL.method_2856(0.5F, 4.5F, -2.49F, 3, 6, 5, s);
		this.armLpauldron = new class_630(this, 0, 40);
		this.armLpauldron.field_3666 = true;
		this.armLpauldron.method_2851(0.0F, 0.0F, 0.0F);
		this.armLpauldron.method_2856(-0.5F, -3.0F, -3.0F, 6, 7, 6, s);
		this.armLwing1 = new class_630(this, 40, 35);
		this.armLwing1.method_2851(6.0F, -1.0F, 0.0F);
		this.armLwing1.method_2856(0.0F, -4.0F, 0.0F, 0, 4, 5, s);
		this.setRotateAngle(armLwing1, 0.2617993877991494F, 0.5235987755982988F, 0.2617993877991494F);
		this.armLwing2 = new class_630(this, 40, 40);
		this.armLwing2.method_2851(6.0F, -1.0F, 0.0F);
		this.armLwing2.method_2856(0.0F, 0.0F, 0.0F, 0, 3, 4, s);
		this.setRotateAngle(armLwing2, -0.2617993877991494F, 0.2617993877991494F, -0.2617993877991494F);

		//armR
		this.armRAnchor = new class_630(this, 0, 0);
		this.armRAnchor.field_3666 = true;
		this.armRAnchor.method_2851(-4.0F, 2.0F, 0.0F);
		this.armRAnchor.method_2856(-2.0F, -1.0F, -1.0F, 2, 2, 2, s);
		this.armR = new class_630(this, 24, 40);
		this.armR.method_2851(0.0F, 0.0F, 0.0F);
		this.armR.method_2856(-3.5F, 4.5F, -2.51F, 3, 6, 5, s);
		this.armRpauldron = new class_630(this, 0, 40);
		this.armRpauldron.method_2851(0.0F, 0.0F, 0.0F);
		this.armRpauldron.method_2856(-5.5F, -3.0F, -3.0F, 6, 7, 6, s);
		this.setRotateAngle(armRpauldron, 0.0F, 0.0F, 0.0017453292519943296F);
		this.armRwing1 = new class_630(this, 40, 35);
		this.armRwing1.field_3666 = true;
		this.armRwing1.method_2851(-6.5F, -1.0F, 0.0F);
		this.armRwing1.method_2856(0.0F, -4.0F, 0.0F, 0, 4, 5, s);
		this.setRotateAngle(armRwing1, 0.2617993877991494F, -0.5235987755982988F, -0.2617993877991494F);
		this.armRwing2 = new class_630(this, 40, 40);
		this.armRwing2.field_3666 = true;
		this.armRwing2.method_2851(-6.5F, -1.0F, 0.0F);
		this.armRwing2.method_2856(0.0F, 0.0F, 0.0F, 0, 3, 4, s);
		this.setRotateAngle(armRwing2, -0.2617993877991494F, -0.2617993877991494F, 0.2617993877991494F);

		//pants
		this.pantsAnchor = new class_630(this, 0, 0);
		this.pantsAnchor.method_2851(0.0F, 0.0F, 0.0F);
		this.pantsAnchor.method_2856(-1.0F, 0.0F, -1.0F, 2, 2, 2, s);
		this.belt = new class_630(this, 0, 53);
		this.belt.method_2851(0.0F, 0.0F, 0.0F);
		this.belt.method_2856(-4.5F, 8.0F, -3.0F, 9, 5, 6, s);
		this.legL = new class_630(this, 0, 64);
		this.legL.field_3666 = true;
		this.legL.method_2851(1.9F, 12.0F, 0.0F);
		this.legL.method_2856(-2.39F, 0.0F, -2.49F, 5, 6, 5, s);
		this.legR = new class_630(this, 0, 64);
		this.legR.method_2851(-1.9F, 12.0F, 0.0F);
		this.legR.method_2856(-2.61F, 0.0F, -2.51F, 5, 6, 5, s);

		//boots
		this.bootL = new class_630(this, 0, 75);
		this.bootL.field_3666 = true;
		this.bootL.method_2851(1.9F, 12.0F, 0.0F);
		this.bootL.method_2856(-2.39F, 8.5F, -2.49F, 5, 5, 5, s);
		this.bootLwing1 = new class_630(this, 40, 40);
		this.bootLwing1.method_2851(2.5F, 8.5F, 0.0F);
		this.bootLwing1.method_2856(0.0F, -3.0F, 0.0F, 0, 3, 4, s);
		this.setRotateAngle(bootLwing1, 0.2617993877991494F, 0.5235987755982988F, 0.2617993877991494F);
		this.bootLwing2 = new class_630(this, 40, 44);
		this.bootLwing2.method_2851(2.5F, 8.5F, 0.0F);
		this.bootLwing2.method_2856(0.0F, 0.0F, 0.0F, 0, 2, 3, s);
		this.setRotateAngle(bootLwing2, -0.2617993877991494F, 0.2617993877991494F, -0.2617993877991494F);
		this.bootR = new class_630(this, 0, 75);
		this.bootR.method_2851(-1.9F, 12.0F, 0.0F);
		this.bootR.method_2856(-2.61F, 8.5F, -2.51F, 5, 5, 5, s);
		this.bootRwing1 = new class_630(this, 40, 40);
		this.bootRwing1.field_3666 = true;
		this.bootRwing1.method_2851(-2.6F, 8.5F, 0.0F);
		this.bootRwing1.method_2856(0.0F, -3.0F, 0.0F, 0, 3, 4, s);
		this.setRotateAngle(bootRwing1, 0.2617993877991494F, -0.5235987755982988F, -0.2617993877991494F);
		this.bootRwing2 = new class_630(this, 40, 44);
		this.bootRwing2.field_3666 = true;
		this.bootRwing2.method_2851(-2.5F, 8.5F, 0.0F);
		this.bootRwing2.method_2856(0.0F, 0.0F, 0.0F, 0, 2, 3, s);
		this.setRotateAngle(bootRwing2, -0.2617993877991494F, -0.2617993877991494F, 0.2617993877991494F);

		//hierarchy
		this.helmAnchor.method_2845(this.helm);
		this.helm.method_2845(this.helmFairy);
		this.helm.method_2845(this.helmWing1l);
		this.helm.method_2845(this.helmWing2l);
		this.helm.method_2845(this.helmWing1r);
		this.helm.method_2845(this.helmWing2r);

		this.bodyAnchor.method_2845(this.bodyTop);
		this.bodyTop.method_2845(this.bodyBottom);
		this.armLAnchor.method_2845(this.armL);
		this.armL.method_2845(this.armLpauldron);
		this.armLpauldron.method_2845(this.armLwing1);
		this.armLpauldron.method_2845(this.armLwing2);
		this.armRAnchor.method_2845(this.armR);
		this.armR.method_2845(this.armRpauldron);
		this.armRpauldron.method_2845(this.armRwing1);
		this.armRpauldron.method_2845(this.armRwing2);

		this.pantsAnchor.method_2845(this.belt);

		this.bootL.method_2845(bootLwing1);
		this.bootL.method_2845(bootLwing2);
		this.bootR.method_2845(bootRwing1);
		this.bootR.method_2845(bootRwing2);
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a) {

		helmAnchor.field_3665 = slot == class_1304.field_6169;
		bodyAnchor.field_3665 = slot == class_1304.field_6174;
		armRAnchor.field_3665 = slot == class_1304.field_6174;
		armLAnchor.field_3665 = slot == class_1304.field_6174;
		legR.field_3665 = slot == class_1304.field_6172;
		legL.field_3665 = slot == class_1304.field_6172;
		bootL.field_3665 = slot == class_1304.field_6166;
		bootR.field_3665 = slot == class_1304.field_6166;
		field_3394.field_3665 = false;

		field_3398 = helmAnchor;
		field_3391 = bodyAnchor;
		field_3401 = armRAnchor;
		field_3390 = armLAnchor;
		if (slot == class_1304.field_6172) {
			field_3391 = pantsAnchor;
			field_3392 = legR;
			field_3397 = legL;
		} else {
			field_3392 = bootR;
			field_3397 = bootL;
		}

		super.method_2828(ms, buffer, light, overlay, r, g, b, a);
	}
}
