/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TilePlatform;

import java.util.Random;
import java.util.function.Supplier;

public class PlatformModel extends ForwardingBakedModel {
	public PlatformModel(class_1087 original) {
		this.wrapped = original;
	}

	@Override
	public boolean isVanillaAdapter() {
		return false;
	}

	@Override
	public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
		if (!(state.method_26204() instanceof BlockPlatform)) {
			context.fallbackConsumer().accept(class_310.method_1551().method_1541().method_3351().method_3333().method_4744());
			return;
		}

		Object data = ((RenderAttachedBlockView) blockView).getBlockEntityRenderAttachment(pos);
		if (data instanceof TilePlatform.PlatformData) {
			class_2338 heldPos = ((TilePlatform.PlatformData) data).pos;
			class_2680 heldState = ((TilePlatform.PlatformData) data).state;

			if (heldState == null) {
				// No camo
				super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
			} else {
				// Some people used this to get an invisible block in the past, accommodate that.
				if (heldState.method_26204() == ModBlocks.manaGlass) {
					return;
				}

				class_1087 model = class_310.method_1551().method_1541().method_3351().method_3335(heldState);
				if (model instanceof FabricBakedModel) {
					// Steal camo's model
					((FabricBakedModel) model).emitBlockQuads(blockView, heldState, heldPos, randomSupplier, context);
				}
			}
		}
	}

}
