/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_583;
import net.minecraft.class_630;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.helper.ShaderWrappedRenderLayer;
import vazkii.botania.client.render.entity.RenderPixie;
import vazkii.botania.common.entity.EntityPixie;

public class ModelPixie extends class_583<EntityPixie> {
	public class_630 body;
	public class_630 leftWingT;
	public class_630 leftWingB;
	public class_630 rightWingT;
	public class_630 rightWingB;

	private static boolean evil = false;

	private static class_1921 pixieLayer(class_2960 texture) {
		class_1921 normal = class_1921.method_23578(texture);
		return evil && ShaderHelper.useShaders()
				? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.DOPPLEGANGER, RenderPixie.SHADER_CALLBACK, normal)
				: normal;
	}

	public ModelPixie() {
		super(ModelPixie::pixieLayer);
		field_17138 = 32;
		field_17139 = 32;

		body = new class_630(this, 0, 0);
		body.method_2851(0.0F, 16.0F, 0.0F);
		body.method_2856(-2.5F, 0.0F, -2.5F, 5, 5, 5, 0.0F);

		leftWingT = new class_630(this, 0, 4);
		leftWingT.method_2851(2.5F, 18.0F, 0.5F);
		leftWingT.method_2856(0.0F, -5.0F, 0.0F, 0, 5, 6, 0.0F);
		setRotateAngle(leftWingT, 0.2617993877991494F, 0.5235987755982988F, 0.2617993877991494F);
		leftWingB = new class_630(this, 0, 11);
		leftWingB.method_2851(2.5F, 18.0F, 0.5F);
		leftWingB.method_2856(0.0F, 0.0F, 0.0F, 0, 3, 4, 0.0F);
		setRotateAngle(leftWingB, -0.2617993877991494F, 0.2617993877991494F, -0.2617993877991494F);
		rightWingT = new class_630(this, 0, 4);
		rightWingT.method_2851(-2.5F, 18.0F, 0.5F);
		rightWingT.method_2856(0.0F, -5.0F, 0.0F, 0, 5, 6, 0.0F);
		setRotateAngle(rightWingT, 0.2617993877991494F, -0.5235987755982988F, -0.2617993877991494F);
		rightWingB = new class_630(this, 0, 11);
		rightWingB.method_2851(-2.5F, 18.0F, 0.5F);
		rightWingB.method_2856(0.0F, 0.0F, 0.0F, 0, 3, 4, 0.0F);
		setRotateAngle(rightWingB, -0.2617993877991494F, -0.2617993877991494F, 0.2617993877991494F);
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float red, float green, float blue, float alpha) {
		body.method_22698(ms, buffer, light, overlay);

		leftWingT.method_22698(ms, buffer, light, overlay);
		leftWingB.method_22698(ms, buffer, light, overlay);
		rightWingT.method_22698(ms, buffer, light, overlay);
		rightWingB.method_22698(ms, buffer, light, overlay);
	}

	public void setRotateAngle(class_630 modelRenderer, float x, float y, float z) {
		modelRenderer.field_3654 = x;
		modelRenderer.field_3675 = y;
		modelRenderer.field_3674 = z;
	}

	@Override
	public void setAngles(EntityPixie entity, float f, float f1, float f2, float f3, float f4) {
		evil = entity.getPixieType() == 1;
		rightWingT.field_3675 = -(class_3532.method_15362(f2 * 1.7F) * (float) Math.PI * 0.5F);
		leftWingT.field_3675 = class_3532.method_15362(f2 * 1.7F) * (float) Math.PI * 0.5F;
		rightWingB.field_3675 = -(class_3532.method_15362(f2 * 1.7F) * (float) Math.PI * 0.25F);
		leftWingB.field_3675 = class_3532.method_15362(f2 * 1.7F) * (float) Math.PI * 0.25F;
	}

}
