/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class ModelHourglass extends class_3879 {

	public class_630 top;
	public class_630 glassT;
	public class_630 ring;
	public class_630 glassB;
	public class_630 bottom;

	public class_630 sandT;
	public class_630 sandB;

	public ModelHourglass() {
		super(class_1921::method_23580);

		field_17138 = 64;
		field_17139 = 32;

		top = new class_630(this, 20, 0);
		top.method_2851(0.0F, 0.0F, 0.0F);
		top.method_2856(-3.0F, -6.5F, -3.0F, 6, 1, 6, 0.0F);
		glassT = new class_630(this, 0, 0);
		glassT.method_2851(0.0F, 0.0F, 0.0F);
		glassT.method_2856(-2.5F, -5.5F, -2.5F, 5, 5, 5, 0.0F);
		ring = new class_630(this, 0, 20);
		ring.method_2851(0.0F, 0.0F, 0.0F);
		ring.method_2856(-1.5F, -0.5F, -1.5F, 3, 1, 3, 0.0F);
		glassB = new class_630(this, 0, 10);
		glassB.method_2851(0.0F, 0.0F, 0.0F);
		glassB.method_2856(-2.5F, 0.5F, -2.5F, 5, 5, 5, 0.0F);
		bottom = new class_630(this, 20, 7);
		bottom.method_2851(0.0F, 0.0F, 0.0F);
		bottom.method_2856(-3.0F, 5.5F, -3.0F, 6, 1, 6, 0.0F);

		sandT = new class_630(this, 20, 14);
		sandT.method_2851(0.0F, 0.0F, 0.0F);
		sandT.method_2856(0.0F, 0.0F, 0.0F, 4, 4, 4, 0.0F); // -2.0F, -5.0F, -2.0F
		sandB = new class_630(this, 20, 14);
		sandB.method_2851(0.0F, 0.0F, 0.0F);
		sandB.method_2856(0.0F, 0.0F, 0.0F, 4, 4, 4, 0.0F); // -2.0F, 1.0F, -2.05F
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a) {
		render(ms, buffer, light, overlay, r, g, b, a, 0, 1, false);
	}

	public void render(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a, float fract1, float fract2, boolean flip) {
		if (flip) {
			float tmp = fract1;
			fract1 = fract2;
			fract2 = tmp;
		}

		float f = 1F / 16F;
		ring.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);
		top.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);
		bottom.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);

		if (fract1 > 0) {
			ms.method_22903();
			if (flip) {
				ms.method_22904(-2.0F * f, 1.0F * f, -2.0F * f);
			} else {
				ms.method_22907(class_1160.field_20707.method_23214(180F));
				ms.method_22904(-2.0F * f, -5.0F * f, -2.0F * f);
			}
			ms.method_22905(1F, fract1, 1F);
			sandT.method_22699(ms, buffer, light, overlay, r, g, b, a);
			ms.method_22909();
		}

		if (fract2 > 0) {
			ms.method_22903();
			if (flip) {
				ms.method_22904(-2.0F * f, -5.0F * f, -2.0F * f);
			} else {
				ms.method_22907(class_1160.field_20707.method_23214(180F));
				ms.method_22904(-2.0F * f, 1.0F * f, -2.0F * f);
			}
			ms.method_22905(1F, fract2, 1F);
			sandB.method_22699(ms, buffer, light, overlay, r, g, b, a);
			ms.method_22909();
		}

		glassT.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);
		glassB.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);
	}

}
