/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.tuple.Pair;

import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.mixin.AccessorModelBakery;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_806;
import net.minecraft.class_809;
import java.util.*;
import java.util.function.Function;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class GunModel implements class_1087 {
	private static final class_1091 DESU = new class_1091(LibMisc.MOD_ID + ":desu_gun", "inventory");
	private static final class_1091 DESU_CLIP = new class_1091(LibMisc.MOD_ID + ":desu_gun_clip", "inventory");

	private final net.minecraft.class_1088 bakery;
	private final class_1087 originalModel;
	private final class_1087 originalModelClip;

	public GunModel(net.minecraft.class_1088 bakery, class_1087 originalModel, class_1087 originalModelClip) {
		this.bakery = bakery;
		this.originalModel = Preconditions.checkNotNull(originalModel);
		this.originalModelClip = Preconditions.checkNotNull(originalModelClip);
	}

	private final class_806 itemHandler = new class_806() {
		@Nonnull
		@Override
		public class_1087 method_3495(class_1087 model, class_1799 stack, @Nullable class_638 worldIn, @Nullable class_1309 entityIn) {
			boolean clip = ItemManaGun.hasClip(stack);

			if (ItemManaGun.isSugoiKawaiiDesuNe(stack)) {
				return class_310.method_1551().method_1554().method_4742(clip ? DESU_CLIP : DESU);
			}

			class_1799 lens = ItemManaGun.getLens(stack);
			if (!lens.method_7960()) {
				return GunModel.this.getModel(lens, clip);
			} else {
				return clip ? originalModelClip : originalModel;
			}
		}
	};

	@Nonnull
	@Override
	public class_806 method_4710() {
		return itemHandler;
	}

	@Nonnull
	@Override
	public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, @Nonnull Random rand) {
		return originalModel.method_4707(state, side, rand);
	}

	@Override
	public boolean method_4708() {
		return originalModel.method_4708();
	}

	@Override
	public boolean method_4712() {
		return originalModel.method_4712();
	}

	@Override
	public boolean method_4713() {
		return originalModel.method_4713();
	}

	@Nonnull
	@Override
	public class_1058 method_4711() {
		return originalModel.method_4711();
	}

	@Nonnull
	@Override
	public class_809 method_4709() {
		return originalModel.method_4709();
	}

	@Override
	public boolean method_24304() {
		return originalModel.method_24304();
	}

	private final HashMap<Pair<class_1792, Boolean>, CompositeBakedModel> cache = new HashMap<>();

	private CompositeBakedModel getModel(class_1799 lens, boolean clip) {
		return cache.computeIfAbsent(Pair.of(lens.method_7909(), clip), p -> new CompositeBakedModel(bakery, lens, clip ? originalModelClip : originalModel));
	}

	private static class CompositeBakedModel extends DelegatedModel {
		private final List<class_777> genQuads = new ArrayList<>();
		private final Map<class_2350, List<class_777>> faceQuads = new EnumMap<>(class_2350.class);

		CompositeBakedModel(net.minecraft.class_1088 bakery, class_1799 lens, class_1087 gun) {
			super(gun);

			class_2960 lensId = class_2378.field_11142.method_10221(lens.method_7909());
			class_1100 lensUnbaked = bakery.method_4726(new class_1091(lensId, "inventory"));
			class_3665 transform = new class_3665() {
				@Override
				public class_4590 method_3509() {
					return new class_4590(new class_1160(-0.4F, 0.2F, 0.0F), class_1160.field_20705.method_23626((float) Math.PI / 2), new class_1160(0.625F, 0.625F, 0.625F), null);
				}
			};
			class_2960 name = prefix("gun_with_" + lensId.toString().replace(':', '_'));

			Function<class_4730, class_1058> textureGetter = ((AccessorModelBakery) bakery).getSpriteAtlasManager()::method_24097;
			class_1087 lensBaked;
			if (lensUnbaked instanceof class_793 && ((class_793) lensUnbaked).method_3431() == net.minecraft.class_1088.field_5400) {
				class_793 bm = (class_793) lensUnbaked;
				lensBaked = new class_801()
						.method_3479(textureGetter, bm)
						.method_3446(bakery, bm, textureGetter, transform, name, false);
			} else {
				lensBaked = lensUnbaked.method_4753(bakery, textureGetter, transform, name);
			}

			for (class_2350 e : class_2350.values()) {
				faceQuads.put(e, new ArrayList<>());
			}

			Random rand = new Random(0);
			genQuads.addAll(lensBaked.method_4707(null, null, rand));

			for (class_2350 e : class_2350.values()) {
				rand.setSeed(0);
				faceQuads.get(e).addAll(lensBaked.method_4707(null, e, rand));
			}

			// Add gun quads
			rand.setSeed(0);
			genQuads.addAll(gun.method_4707(null, null, rand));
			for (class_2350 e : class_2350.values()) {
				rand.setSeed(0);
				faceQuads.get(e).addAll(gun.method_4707(null, e, rand));
			}
		}

		@Nonnull
		@Override
		public List<class_777> method_4707(class_2680 state, class_2350 face, @Nonnull Random rand) {
			return face == null ? genQuads : faceQuads.get(face);
		}
	}

}
