/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.gui.bag;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1074;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.ModItems;

public class GuiFlowerBag extends class_465<ContainerFlowerBag> {

	private static final class_2960 texture = new class_2960(LibResources.GUI_FLOWER_BAG);

	public GuiFlowerBag(ContainerFlowerBag container, class_1661 playerInv, class_2561 title) {
		super(container, playerInv, title);
	}

	@Override
	public void method_25394(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
		this.method_25420(ms);
		super.method_25394(ms, mouseX, mouseY, partialTicks);
		this.method_2380(ms, mouseX, mouseY);
	}

	@Override
	protected void method_2388(class_4587 ms, int mouseX, int mouseY) {
		String s = class_1074.method_4662(ModItems.flowerBag.method_7876());
		field_22793.method_1729(ms, s, field_2792 / 2 - field_22793.method_1727(s) / 2, 6, 4210752);
		field_22793.method_1729(ms, class_1074.method_4662("container.inventory"), 8, field_2779 - 96 + 2, 4210752);
	}

	@Override
	protected void method_2389(class_4587 ms, float partialTicks, int mouseX, int mouseY) {
		class_310 mc = class_310.method_1551();
		RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
		mc.method_1531().method_22813(texture);
		int k = (field_22789 - field_2792) / 2;
		int l = (field_22790 - field_2779) / 2;
		method_25302(ms, k, l, 0, 0, field_2792, field_2779);

		for (class_1735 slot : field_2797.field_7761) {
			if (slot.field_7871 == field_2797.flowerBagInv && !slot.method_7681()) {
				class_1767 color = class_1767.method_7791(slot.field_7874);
				class_1799 stack = new class_1799(ModBlocks.getFlower(color));
				int x = this.field_2776 + slot.field_7873;
				int y = this.field_2800 + slot.field_7872;
				mc.method_1480().method_4010(stack, x, y);
				mc.field_1772.method_1720(ms, "0", x + 11, y + 9, 0xFF6666);
			}
		}
	}

}
