/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.fx;

import com.mojang.serialization.Codec;
import javax.annotation.Nonnull;
import net.minecraft.class_2396;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class WispParticleType extends class_2396<WispParticleData> {
	public WispParticleType() {
		super(false, WispParticleData.DESERIALIZER);
	}

	@Nonnull
	@Override
	public Codec<WispParticleData> method_29138() {
		return WispParticleData.CODEC;
	}

	public static class Factory implements class_707<WispParticleData> {
		private final class_4002 sprite;

		public Factory(class_4002 sprite) {
			this.sprite = sprite;
		}

		@Override
		public class_703 createParticle(WispParticleData data, class_638 world, double x, double y, double z, double mx, double my, double mz) {
			FXWisp ret = new FXWisp(world, x, y, z, mx, my, mz, data.size, data.r, data.g, data.b, data.depthTest, data.maxAgeMul, data.noClip);
			ret.method_18140(sprite);
			return ret;
		}
	}
}
