/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.fx;

import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.minecraft.class_2378;
import net.minecraft.class_2396;

import static vazkii.botania.common.block.ModBlocks.register;

public class ModParticles {
	public static final class_2396<WispParticleData> WISP = new WispParticleType();
	public static final class_2396<SparkleParticleData> SPARKLE = new SparkleParticleType();

	public static void registerParticles() {
		register(class_2378.field_11141, "wisp", WISP);
		register(class_2378.field_11141, "sparkle", SPARKLE);
	}

	public static class FactoryHandler {
		public static void registerFactories() {
			ParticleFactoryRegistry.getInstance().register(ModParticles.WISP, WispParticleType.Factory::new);
			ParticleFactoryRegistry.getInstance().register(ModParticles.SPARKLE, SparkleParticleType.Factory::new);
		}
	}
}
