/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.opengl.GL11;

import vazkii.botania.client.core.ExtendedTexture;
import vazkii.botania.client.core.helper.ShaderHelper;

import javax.annotation.Nonnull;
import net.minecraft.class_1044;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;

public class FXSparkle extends class_4003 {
	private final boolean corrupt;
	public final boolean fake;
	public final int particle = 16;
	private final boolean slowdown = true;
	private final class_4002 sprite;

	public FXSparkle(class_638 world, double x, double y, double z, float size,
			float red, float green, float blue, int m,
			boolean fake, boolean noClip, boolean corrupt, class_4002 sprite) {
		super(world, x, y, z, 0.0D, 0.0D, 0.0D);
		field_3861 = red;
		field_3842 = green;
		field_3859 = blue;
		field_3841 = 0.75F;
		field_3844 = 0;
		field_3852 = field_3869 = field_3850 = 0;
		field_17867 = (this.field_3840.nextFloat() * 0.5F + 0.5F) * 0.2F * size;
		field_3847 = 3 * m;
		method_3080(0.01F, 0.01F);
		field_3858 = x;
		field_3838 = y;
		field_3856 = z;
		this.fake = fake;
		this.corrupt = corrupt;
		this.field_3862 = !fake && !noClip;
		this.sprite = sprite;
		method_18142(sprite);
	}

	@Override
	public float method_18132(float partialTicks) {
		return field_17867 * (field_3847 - field_3866 + 1) / (float) field_3847;
	}

	@Override
	public void method_3070() {
		method_18142(sprite);
		field_3858 = field_3874;
		field_3838 = field_3854;
		field_3856 = field_3871;

		if (field_3866++ >= field_3847) {
			method_3085();
		}

		field_3869 -= 0.04D * field_3844;

		if (field_3862 && !fake) {
			wiggleAround(field_3874, (method_3064().field_1322 + method_3064().field_1325) / 2.0D, field_3871);
		}

		this.method_3069(field_3852, field_3869, field_3850);

		if (slowdown) {
			field_3852 *= 0.908000001907348633D;
			field_3869 *= 0.908000001907348633D;
			field_3850 *= 0.908000001907348633D;

			if (field_3845) {
				field_3852 *= 0.69999998807907104D;
				field_3850 *= 0.69999998807907104D;
			}
		}

		if (fake && field_3866 > 1) {
			method_3085();
		}
	}

	@Nonnull
	@Override
	public class_3999 method_18122() {
		return corrupt ? CORRUPT_RENDER : NORMAL_RENDER;
	}

	public void setGravity(float value) {
		field_3844 = value;
	}

	// [VanillaCopy] Entity.pushOutOfBlocks with tweaks
	private void wiggleAround(double x, double y, double z) {
		class_2338 blockpos = new class_2338(x, y, z);
		class_243 Vector3d = new class_243(x - (double) blockpos.method_10263(), y - (double) blockpos.method_10264(), z - (double) blockpos.method_10260());
		class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
		class_2350 direction = class_2350.field_11036;
		double d0 = Double.MAX_VALUE;

		for (class_2350 direction1 : new class_2350[] { class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034, class_2350.field_11036 }) {
			blockpos$mutable.method_10101(blockpos).method_10098(direction1);
			if (!this.field_3851.method_8320(blockpos$mutable).method_26234(this.field_3851, blockpos$mutable)) {
				double d1 = Vector3d.method_18043(direction1.method_10166());
				double d2 = direction1.method_10171() == class_2350.class_2352.field_11056 ? 1.0D - d1 : d1;
				if (d2 < d0) {
					d0 = d2;
					direction = direction1;
				}
			}
		}

		// Botania - made multiplier and add both smaller
		float f = this.field_3840.nextFloat() * 0.05F + 0.025F;
		float f1 = (float) direction.method_10171().method_10181();
		// Botania - Randomness in other axes as well
		float secondary = (field_3840.nextFloat() - field_3840.nextFloat()) * 0.1F;
		float secondary2 = (field_3840.nextFloat() - field_3840.nextFloat()) * 0.1F;
		if (direction.method_10166() == class_2350.class_2351.field_11048) {
			field_3852 = (double) (f1 * f);
			field_3869 = secondary;
			field_3850 = secondary2;
		} else if (direction.method_10166() == class_2350.class_2351.field_11052) {
			field_3852 = secondary;
			field_3869 = (double) (f1 * f);
			field_3850 = secondary2;
		} else if (direction.method_10166() == class_2350.class_2351.field_11051) {
			field_3852 = secondary;
			field_3869 = secondary2;
			field_3850 = (double) (f1 * f);
		}
	}

	private static void beginRenderCommon(class_287 buffer, class_1060 textureManager) {
		RenderSystem.depthMask(false);
		RenderSystem.enableBlend();
		RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE);
		RenderSystem.alphaFunc(GL11.GL_GREATER, 0.003921569F);
		RenderSystem.disableLighting();
		textureManager.method_22813(class_1059.field_17898);
		class_1044 tex = textureManager.method_4619(class_1059.field_17898);
		((ExtendedTexture) tex).setFilterSave(true, false);
		buffer.method_1328(GL11.GL_QUADS, class_290.field_1584);
	}

	private static void endRenderCommon() {
		class_1044 tex = class_310.method_1551().method_1531().method_4619(class_1059.field_17898);
		((ExtendedTexture) tex).restoreLastFilter();
		RenderSystem.alphaFunc(GL11.GL_GREATER, 0.1F);
		RenderSystem.disableBlend();
		RenderSystem.depthMask(true);
	}

	public static final class_3999 NORMAL_RENDER = new class_3999() {
		@Override
		public void method_18130(class_287 bufferBuilder, class_1060 textureManager) {
			beginRenderCommon(bufferBuilder, textureManager);
		}

		@Override
		public void method_18131(class_289 tessellator) {
			tessellator.method_1350();
			endRenderCommon();
		}

		@Override
		public String toString() {
			return "botania:sparkle";
		}
	};

	public static final class_3999 CORRUPT_RENDER = new class_3999() {
		@Override
		public void method_18130(class_287 bufferBuilder, class_1060 textureManager) {
			beginRenderCommon(bufferBuilder, textureManager);
			ShaderHelper.useShader(ShaderHelper.BotaniaShader.FILM_GRAIN);
		}

		@Override
		public void method_18131(class_289 tessellator) {
			tessellator.method_1350();
			ShaderHelper.releaseShader();
			endRenderCommon();
		}

		@Override
		public String toString() {
			return "botania:corrupt_sparkle";
		}
	};
}
