/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import org.lwjgl.opengl.GL11;

import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.core.helper.Vector3;

import javax.annotation.Nonnull;
import net.minecraft.class_1060;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import java.util.*;

// Originally taken with permission from WRCBE - heavily modified
public class FXLightning extends class_703 {

	private static final class_2960 outsideResource = new class_2960(LibResources.MISC_WISP_LARGE);
	private static final class_2960 insideResource = new class_2960(LibResources.MISC_WISP_SMALL);
	private static final int fadetime = 20;
	private final int expandTime;
	private final int colorOuter;
	private final int colorInner;

	private final List<FXLightningSegment> segments;
	private final int segmentCount;

	public FXLightning(class_638 world, Vector3 sourcevec, Vector3 targetvec, float speed, long seed, int colorOuter, int colorInner) {
		super(world, sourcevec.x, sourcevec.y, sourcevec.z);
		this.colorOuter = colorOuter;
		this.colorInner = colorInner;
		double length = targetvec.subtract(sourcevec).mag();
		field_3847 = fadetime + world.field_9229.nextInt(fadetime) - fadetime / 2;
		expandTime = (int) (length * speed);
		field_3866 = -(int) (length * speed);

		LightningSegmentGenerator gen = new LightningSegmentGenerator(seed);
		Pair<Integer, List<FXLightningSegment>> res = gen.compute(sourcevec, targetvec, length);
		segmentCount = res.getFirst();
		segments = res.getSecond();
	}

	@Override
	public void method_3074(class_4588 buffer, class_4184 info, float partialTicks) {
		// todo fix this >.>

		// old way (bad position and too thick)
		// LightningHandler.queuedLightningBolts.offer(this);

		// new way (right position but heavy artifacting)

		class_243 cameraPos = info.method_19326();
		class_4587 ms = new class_4587();
		// 0.25f offset for a more pleasing viewing experience
		ms.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214() + 0.25F, -cameraPos.method_10215());
		renderBolt(ms, buffer, 0, false);
		renderBolt(ms, buffer, 1, true);
	}

	@Nonnull
	@Override
	public class_3999 method_18122() {
		return RENDER;
	}

	public void renderBolt(class_4587 ms, class_4588 wr, int pass, boolean inner) {
		class_1159 mat = ms.method_23760().method_23761();

		float boltAge = field_3866 < 0 ? 0 : (float) field_3866 / (float) field_3847;
		float mainAlpha;
		if (pass == 0) {
			class_310.method_1551().method_1531().method_22813(outsideResource);
			mainAlpha = (1 - boltAge) * 0.4F;
		} else {
			class_310.method_1551().method_1531().method_22813(insideResource);
			mainAlpha = 1 - boltAge * 0.5F;
		}

		int renderstart = (int) ((expandTime / 2 - field_3847 + field_3866) / (float) (expandTime / 2) * segmentCount);
		int renderend = (int) ((field_3866 + expandTime) / (float) expandTime * segmentCount);

		for (FXLightningSegment rendersegment : segments) {
			if (rendersegment.segmentNo < renderstart || rendersegment.segmentNo > renderend) {
				continue;
			}

			Vector3 playerVec = getRelativeViewVector(rendersegment.startPoint.point).multiply(-1);

			double width = 0.025F * (playerVec.mag() / 5 + 1) * (1 + rendersegment.light) * 0.5F;

			Vector3 diff1 = playerVec.crossProduct(rendersegment.prevDiff).normalize().multiply(width / rendersegment.sinPrev);
			Vector3 diff2 = playerVec.crossProduct(rendersegment.nextDiff).normalize().multiply(width / rendersegment.sinNext);

			Vector3 startvec = rendersegment.startPoint.point;
			Vector3 endvec = rendersegment.endPoint.point;

			int color = inner ? colorInner : colorOuter;
			int r = (color & 0xFF0000) >> 16;
			int g = (color & 0xFF00) >> 8;
			int b = color & 0xFF;
			int a = (int) (mainAlpha * rendersegment.light * 0xFF);
			int fullbright = 0xF000F0;

			endvec.subtract(diff2).vertex(mat, wr);
			wr.method_1336(r, g, b, a).method_22913(0.5F, 0).method_22916(fullbright).method_1344();
			startvec.subtract(diff1).vertex(mat, wr);
			wr.method_1336(r, g, b, a).method_22913(0.5F, 0).method_22916(fullbright).method_1344();
			startvec.add(diff1).vertex(mat, wr);
			wr.method_1336(r, g, b, a).method_22913(0.5F, 1).method_22916(fullbright).method_1344();
			endvec.add(diff2).vertex(mat, wr);
			wr.method_1336(r, g, b, a).method_22913(0.5F, 1).method_22916(fullbright).method_1344();

			if (rendersegment.next == null) {
				Vector3 roundend = rendersegment.endPoint.point.add(rendersegment.diff.normalize().multiply(width));

				roundend.subtract(diff2).vertex(mat, wr);
				wr.method_1336(r, g, b, a).method_22913(0, 0).method_22916(fullbright).method_1344();
				endvec.subtract(diff2).vertex(mat, wr);
				wr.method_1336(r, g, b, a).method_22913(0.5F, 0).method_22916(fullbright).method_1344();
				endvec.add(diff2).vertex(mat, wr);
				wr.method_1336(r, g, b, a).method_22913(0.5F, 1).method_22916(fullbright).method_1344();
				roundend.add(diff2).vertex(mat, wr);
				wr.method_1336(r, g, b, a).method_22913(0, 1).method_22916(fullbright).method_1344();
			}

			if (rendersegment.prev == null) {
				Vector3 roundend = rendersegment.startPoint.point.subtract(rendersegment.diff.normalize().multiply(width));

				startvec.subtract(diff1).vertex(mat, wr);
				wr.method_1336(r, g, b, a).method_22913(0.5F, 0).method_22916(fullbright).method_1344();
				roundend.subtract(diff1).vertex(mat, wr);
				wr.method_1336(r, g, b, a).method_22913(0, 0).method_22916(fullbright).method_1344();
				roundend.add(diff1).vertex(mat, wr);
				wr.method_1336(r, g, b, a).method_22913(0, 1).method_22916(fullbright).method_1344();
				startvec.add(diff1).vertex(mat, wr);
				wr.method_1336(r, g, b, a).method_22913(0.5F, 1).method_22916(fullbright).method_1344();
			}
		}
	}

	private static Vector3 getRelativeViewVector(Vector3 pos) {
		class_1297 renderEntity = class_310.method_1551().method_1560();
		return new Vector3((float) renderEntity.method_23317() - pos.x, (float) renderEntity.method_23318() - pos.y, (float) renderEntity.method_23321() - pos.z);
	}

	public static final class_3999 RENDER = new class_3999() {
		@Override
		public void method_18130(class_287 buffer, class_1060 textureManager) {
			RenderSystem.depthMask(false);
			RenderSystem.enableBlend();
			RenderSystem.defaultBlendFunc();
			buffer.method_1328(GL11.GL_QUADS, class_290.field_20888);
		}

		@Override
		public void method_18131(class_289 tess) {
			tess.method_1350();
			RenderSystem.disableBlend();
			RenderSystem.depthMask(true);
		}

		@Override
		public String toString() {
			return "botania:lightning";
		}
	};

}
