/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.proxy;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.class_1007;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1800;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2470;
import net.minecraft.class_2521;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5272;
import net.minecraft.class_916;
import net.minecraft.class_922;
import net.minecraft.class_953;
import net.minecraft.item.*;
import org.lwjgl.glfw.GLFW;

import vazkii.botania.client.core.handler.*;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.fx.FXLightning;
import vazkii.botania.client.fx.ModParticles;
import vazkii.botania.client.render.entity.RenderBabylonWeapon;
import vazkii.botania.client.render.entity.RenderCorporeaSpark;
import vazkii.botania.client.render.entity.RenderDoppleganger;
import vazkii.botania.client.render.entity.RenderMagicLandmine;
import vazkii.botania.client.render.entity.RenderManaStorm;
import vazkii.botania.client.render.entity.RenderNoop;
import vazkii.botania.client.render.entity.RenderPinkWither;
import vazkii.botania.client.render.entity.RenderPixie;
import vazkii.botania.client.render.entity.RenderPoolMinecart;
import vazkii.botania.client.render.entity.RenderSpark;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.core.proxy.IProxy;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.*;
import vazkii.botania.common.item.brew.ItemBrewBase;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;
import vazkii.botania.common.item.equipment.bauble.ItemMagnetRing;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;
import vazkii.botania.common.item.equipment.tool.bow.ItemLivingwoodBow;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraAxe;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.relic.ItemInfiniteFruit;
import vazkii.botania.common.item.rod.ItemTornadoRod;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.world.WorldTypeSkyblock;
import vazkii.botania.mixin.AccessorBiomeGeneratorTypeScreens;
import vazkii.botania.mixin.AccessorRenderTypeBuffers;
import vazkii.patchouli.api.BookDrawScreenCallback;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ClientProxy implements IProxy, ClientModInitializer {

	public static boolean jingleTheBells = false;
	public static boolean dootDoot = false;

	public static class_304 CORPOREA_REQUEST;

	@Override
	public void onInitializeClient() {
		Botania.proxy = this;
		PacketHandler.initClient();

		ShaderHelper.initShaders();

		ModItems.registerGuis();
		ClientLifecycleEvents.CLIENT_STARTED.register(this::loadComplete);
		LivingEntityFeatureRendererRegistrationCallback.EVENT.register(this::initAuxiliaryRender);
		ModelLoadingRegistry.INSTANCE.registerModelProvider(MiscellaneousIcons.INSTANCE::onModelRegister);
		ModelLoadingRegistry.INSTANCE.registerModelProvider(ModelHandler::registerModels);
		ModelHandler.registerRenderers();
		ModParticles.FactoryHandler.registerFactories();

		ItemTooltipCallback.EVENT.register(TooltipHandler::onTooltipEvent);
		ClientTickEvents.END_CLIENT_TICK.register(KonamiHandler::clientTick);
		BookDrawScreenCallback.EVENT.register(KonamiHandler::renderBook);
		HudRenderCallback.EVENT.register(HUDHandler::onDrawScreenPost);
		ClientTickEvents.END_CLIENT_TICK.register(ClientTickHandler::clientTickEnd);

		PersistentVariableHelper.init();
		PersistentVariableHelper.save();

		if (ConfigHandler.CLIENT.enableSeasonalFeatures.getValue()) {
			LocalDateTime now = LocalDateTime.now();
			if (now.getMonth() == Month.DECEMBER && now.getDayOfMonth() >= 16 || now.getMonth() == Month.JANUARY && now.getDayOfMonth() <= 2) {
				jingleTheBells = true;
			}
			if (now.getMonth() == Month.OCTOBER) {
				dootDoot = true;
			}
		}

		registerRenderTypes();
		registerEntityRenderers();

		if (Botania.gardenOfGlassLoaded) {
			AccessorBiomeGeneratorTypeScreens.getAllTypes().add(WorldTypeSkyblock.INSTANCE);
		}

		CORPOREA_REQUEST = new class_304("key.botania_corporea_request", GLFW.GLFW_KEY_C, LibMisc.MOD_NAME);
		KeyBindingHelper.registerKeyBinding(CORPOREA_REQUEST);
		registerPropertyGetters();
		registerArmors();
	}

	private static void registerArmors() {
		List<class_1792> armors = class_2378.field_11142.method_10220()
				.filter(i -> i instanceof ItemManasteelArmor
						&& class_2378.field_11142.method_10221(i).method_12836().equals(LibMisc.MOD_ID))
				.collect(Collectors.toList());

		ArmorRenderingRegistry.ModelProvider p = (entity, stack, slot, original) -> ((ItemManasteelArmor) stack.method_7909()).getArmorModel(entity, stack, slot, original);
		ArmorRenderingRegistry.registerModel(p, armors);

		ArmorRenderingRegistry.TextureProvider t = (entity, stack, slot, secondLayer, suffix, original) -> new class_2960(((ItemManasteelArmor) stack.method_7909()).getArmorTexture(stack, slot));
		ArmorRenderingRegistry.registerTexture(t, armors);
	}

	private static void registerPropertyGetter(class_1935 item, class_2960 id, class_1800 propGetter) {
		FabricModelPredicateProviderRegistry.register(item.method_8389(), id, propGetter);
	}

	private static void registerPropertyGetters() {
		registerPropertyGetter(ModItems.blackHoleTalisman, prefix("active"),
				(stack, world, entity) -> ItemNBTHelper.getBoolean(stack, ItemBlackHoleTalisman.TAG_ACTIVE, false) ? 1 : 0);
		registerPropertyGetter(ModItems.manaBottle, prefix("swigs_taken"),
				(stack, world, entity) -> ItemBottledMana.SWIGS - ItemBottledMana.getSwigsLeft(stack));

		class_2960 vuvuzelaId = prefix("vuvuzela");
		class_1800 isVuvuzela = (stack, world, entity) -> stack.method_7964().getString().toLowerCase(Locale.ROOT).contains("vuvuzela") ? 1 : 0;
		registerPropertyGetter(ModItems.grassHorn, vuvuzelaId, isVuvuzela);
		registerPropertyGetter(ModItems.leavesHorn, vuvuzelaId, isVuvuzela);
		registerPropertyGetter(ModItems.snowHorn, vuvuzelaId, isVuvuzela);

		registerPropertyGetter(ModItems.lexicon, prefix("elven"), (stack, world, living) -> ModItems.lexicon.isElvenItem(stack) ? 1 : 0);
		registerPropertyGetter(ModItems.manaCookie, prefix("totalbiscuit"),
				(stack, world, entity) -> stack.method_7964().getString().toLowerCase(Locale.ROOT).contains("totalbiscuit") ? 1F : 0F);
		registerPropertyGetter(ModItems.slimeBottle, prefix("active"),
				(stack, world, entity) -> stack.method_7985() && stack.method_7969().method_10577(ItemSlimeBottle.TAG_ACTIVE) ? 1.0F : 0.0F);
		registerPropertyGetter(ModItems.spawnerMover, prefix("full"),
				(stack, world, entity) -> ItemSpawnerMover.hasData(stack) ? 1 : 0);
		registerPropertyGetter(ModItems.temperanceStone, prefix("active"),
				(stack, world, entity) -> ItemNBTHelper.getBoolean(stack, ItemTemperanceStone.TAG_ACTIVE, false) ? 1 : 0);
		registerPropertyGetter(ModItems.twigWand, prefix("bindmode"),
				(stack, world, entity) -> ItemTwigWand.getBindMode(stack) ? 1 : 0);

		class_2960 poolFullId = prefix("full");
		class_1800 poolFull = (stack, world, entity) -> {
			class_2248 block = ((class_1747) stack.method_7909()).method_7711();
			boolean renderFull = ((BlockPool) block).variant == BlockPool.Variant.CREATIVE || stack.method_7985() && stack.method_7969().method_10577("RenderFull");
			return renderFull ? 1F : 0F;
		};
		registerPropertyGetter(ModBlocks.manaPool, poolFullId, poolFull);
		registerPropertyGetter(ModBlocks.dilutedPool, poolFullId, poolFull);
		registerPropertyGetter(ModBlocks.creativePool, poolFullId, poolFull);
		registerPropertyGetter(ModBlocks.fabulousPool, poolFullId, poolFull);

		class_1800 brewGetter = (stack, world, entity) -> {
			ItemBrewBase item = ((ItemBrewBase) stack.method_7909());
			return item.getSwigs() - item.getSwigsLeft(stack);
		};
		registerPropertyGetter(ModItems.brewVial, prefix("swigs_taken"), brewGetter);
		registerPropertyGetter(ModItems.brewFlask, prefix("swigs_taken"), brewGetter);

		class_2960 holidayId = prefix("holiday");
		class_1800 holidayGetter = (stack, worldIn, entityIn) -> ClientProxy.jingleTheBells ? 1 : 0;
		registerPropertyGetter(ModItems.manaweaveHelm, holidayId, holidayGetter);
		registerPropertyGetter(ModItems.manaweaveChest, holidayId, holidayGetter);
		registerPropertyGetter(ModItems.manaweaveBoots, holidayId, holidayGetter);
		registerPropertyGetter(ModItems.manaweaveLegs, holidayId, holidayGetter);

		class_1800 ringOnGetter = (stack, worldIn, entityIn) -> ItemMagnetRing.getCooldown(stack) <= 0 ? 1 : 0;
		registerPropertyGetter(ModItems.magnetRing, prefix("active"), ringOnGetter);
		registerPropertyGetter(ModItems.magnetRingGreater, prefix("active"), ringOnGetter);

		registerPropertyGetter(ModItems.elementiumShears, prefix("reddit"),
				(stack, world, entity) -> stack.method_7964().getString().equalsIgnoreCase("dammit reddit") ? 1F : 0F);
		registerPropertyGetter(ModItems.manasteelSword, prefix("elucidator"),
				(stack, world, entity) -> "the elucidator".equals(stack.method_7964().getString().toLowerCase().trim()) ? 1 : 0);
		registerPropertyGetter(ModItems.terraAxe, prefix("active"),
				(stack, world, entity) -> entity instanceof class_1657 && !ItemTerraAxe.shouldBreak((class_1657) entity) ? 0 : 1);
		registerPropertyGetter(ModItems.terraPick, prefix("tipped"),
				(stack, world, entity) -> ItemTerraPick.isTipped(stack) ? 1 : 0);
		registerPropertyGetter(ModItems.terraPick, prefix("active"),
				(stack, world, entity) -> ItemTerraPick.isEnabled(stack) ? 1 : 0);
		registerPropertyGetter(ModItems.infiniteFruit, prefix("boot"),
				(stack, worldIn, entity) -> ItemInfiniteFruit.isBoot(stack) ? 1F : 0F);
		registerPropertyGetter(ModItems.tornadoRod, prefix("active"),
				(stack, world, living) -> ItemTornadoRod.isFlying(stack) ? 1 : 0);

		class_1800 pulling = class_5272.method_27878(class_1802.field_8102, new class_2960("pulling"));
		class_1800 pull = (stack, worldIn, entity) -> {
			if (entity == null) {
				return 0.0F;
			} else {
				ItemLivingwoodBow item = ((ItemLivingwoodBow) stack.method_7909());
				return entity.method_6030() != stack
						? 0.0F
						: (stack.method_7935() - entity.method_6014()) * item.chargeVelocityMultiplier() / 20.0F;
			}
		};
		registerPropertyGetter(ModItems.livingwoodBow, new class_2960("pulling"), pulling);
		registerPropertyGetter(ModItems.livingwoodBow, new class_2960("pull"), pull);
		registerPropertyGetter(ModItems.crystalBow, new class_2960("pulling"), pulling);
		registerPropertyGetter(ModItems.crystalBow, new class_2960("pull"), pull);
	}

	private static void registerRenderTypes() {
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.defaultAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.forestAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.plainsAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.mountainAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.fungalAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.swampAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.desertAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.taigaAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.mesaAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.mossyAltar, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.ghostRail, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.solidVines, class_1921.method_23581());

		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.corporeaCrystalCube, class_1921.method_23583());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.manaGlass, class_1921.method_23583());
		BlockRenderLayerMap.INSTANCE.putBlock(ModFluffBlocks.managlassPane, class_1921.method_23583());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.elfGlass, class_1921.method_23583());
		BlockRenderLayerMap.INSTANCE.putBlock(ModFluffBlocks.alfglassPane, class_1921.method_23583());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.bifrost, class_1921.method_23583());
		BlockRenderLayerMap.INSTANCE.putBlock(ModFluffBlocks.bifrostPane, class_1921.method_23583());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.bifrostPerm, class_1921.method_23583());
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.prism, class_1921.method_23583());

		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.starfield, class_1921.method_23579());
		/* todo 1.16-fabric
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.abstrusePlatform, t -> true);
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.infrangiblePlatform, t -> true);
		BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.spectralPlatform, t -> true);
		*/

		class_2378.field_11146.method_10220().filter(b -> class_2378.field_11146.method_10221(b).method_12836().equals(LibMisc.MOD_ID))
				.forEach(b -> {
					if (b instanceof BlockFloatingFlower || b instanceof class_2356
							|| b instanceof class_2521 || b instanceof BlockModMushroom) {
						BlockRenderLayerMap.INSTANCE.putBlock(b, class_1921.method_23581());
					}
				});
	}

	private static void registerEntityRenderers() {
		EntityRendererRegistry.INSTANCE.register(ModEntities.MANA_BURST, RenderNoop::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.PLAYER_MOVER, RenderNoop::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.FLAME_RING, RenderNoop::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.MAGIC_LANDMINE, RenderMagicLandmine::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.MAGIC_MISSILE, RenderNoop::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.FALLING_STAR, RenderNoop::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.THROWN_ITEM, (m, ctx) -> new class_916(m, ctx.getItemRenderer()));
		EntityRendererRegistry.INSTANCE.register(ModEntities.PIXIE, RenderPixie::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.DOPPLEGANGER, RenderDoppleganger::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.SPARK, RenderSpark::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.CORPOREA_SPARK, RenderCorporeaSpark::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.POOL_MINECART, RenderPoolMinecart::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.PINK_WITHER, RenderPinkWither::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.MANA_STORM, RenderManaStorm::new);
		EntityRendererRegistry.INSTANCE.register(ModEntities.BABYLON_WEAPON, RenderBabylonWeapon::new);

		EntityRendererRegistry.INSTANCE.register(ModEntities.THORN_CHAKRAM, (m, ctx) -> new class_953<>(m, ctx.getItemRenderer()));
		EntityRendererRegistry.INSTANCE.register(ModEntities.VINE_BALL, (m, ctx) -> new class_953<>(m, ctx.getItemRenderer()));
		EntityRendererRegistry.INSTANCE.register(ModEntities.ENDER_AIR_BOTTLE, (m, ctx) -> new class_953<>(m, ctx.getItemRenderer()));
	}

	private void loadComplete(class_310 mc) {
		ColorHandler.init();

		// Needed to prevent mana pools on carts from X-raying through the cart
		SortedMap<class_1921, class_287> layers = ((AccessorRenderTypeBuffers) mc.method_22940()).getEntityBuilders();
		layers.put(RenderHelper.MANA_POOL_WATER, new class_287(RenderHelper.MANA_POOL_WATER.method_22722()));
	}

	private void initAuxiliaryRender(class_1299<? extends class_1309> type, class_922<?, ?> renderer, LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper helper) {
		if (type == class_1299.field_6097 && renderer instanceof class_1007) {
			helper.register(new ContributorFancinessHandler((class_1007) renderer));
			helper.register(new ManaTabletRenderHandler((class_1007) renderer));
			helper.register(new LayerTerraHelmet((class_1007) renderer));
		}
	}

	@Override
	public boolean isTheClientPlayer(class_1309 entity) {
		return entity == class_310.method_1551().field_1724;
	}

	@Override
	public class_1657 getClientPlayer() {
		return class_310.method_1551().field_1724;
	}

	@Override
	public boolean isClientPlayerWearingMonocle() {
		return ItemMonocle.hasMonocle(class_310.method_1551().field_1724);
	}

	@Override
	public long getWorldElapsedTicks() {
		return ClientTickHandler.ticksInGame;
	}

	@Override
	public void lightningFX(Vector3 vectorStart, Vector3 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
		class_310.method_1551().field_1713.method_3058(new FXLightning(class_310.method_1551().field_1687, vectorStart, vectorEnd, ticksPerMeter, seed, colorOuter, colorInner));
	}

	@Override
	public void addBoss(EntityDoppleganger boss) {
		BossBarHandler.bosses.add(boss);
	}

	@Override
	public void removeBoss(EntityDoppleganger boss) {
		BossBarHandler.bosses.remove(boss);
	}

	@Override
	public int getClientRenderDistance() {
		return class_310.method_1551().field_1690.field_1870;
	}

	@Override
	public void addParticleForce(class_1937 world, class_2394 particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
		world.method_8466(particleData, true, x, y, z, xSpeed, ySpeed, zSpeed);
	}

	@Override
	public void addParticleForceNear(class_1937 world, class_2394 particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
		class_4184 info = class_310.method_1551().field_1773.method_19418();
		if (info.method_19332() && info.method_19326().method_1028(x, y, z) <= 1024.0D) {
			addParticleForce(world, particleData, x, y, z, xSpeed, ySpeed, zSpeed);
		}
	}

	@Override
	public void showMultiblock(IMultiblock mb, class_2561 name, class_2338 anchor, class_2470 rot) {
		PatchouliAPI.get().showMultiblock(mb, name, anchor, rot);
	}

	@Override
	public void clearSextantMultiblock() {
		IMultiblock mb = PatchouliAPI.get().getCurrentMultiblock();
		if (mb != null && mb.getID().equals(ItemSextant.MULTIBLOCK_ID)) {
			PatchouliAPI.get().clearMultiblock();
		}
	}

	@Override
	public void runOnClient(Supplier<Runnable> thing) {
		thing.get().run();
	}
}
