/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.opengl.GL11;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.client.render.tile.RenderTilePylon;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.mixin.AccessorRenderState;

import javax.annotation.Nullable;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_4696;
import net.minecraft.class_756;
import net.minecraft.class_777;
import net.minecraft.class_809;
import net.minecraft.class_918;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Random;

public final class RenderHelper {
	private static final class_4668.class_4685 TRANSLUCENT_TRANSPARENCY = AccessorRenderState.getTranslucentTransparency();
	private static final class_1921 STAR;
	public static final class_1921 RECTANGLE;
	public static final class_1921 CIRCLE;
	public static final class_1921 LINE_1;
	public static final class_1921 LINE_1_NO_DEPTH;
	public static final class_1921 LINE_4_NO_DEPTH;
	public static final class_1921 LINE_5_NO_DEPTH;
	public static final class_1921 LINE_8_NO_DEPTH;
	public static final class_1921 SPARK;
	public static final class_1921 LIGHT_RELAY;
	public static final class_1921 SPINNING_CUBE;
	public static final class_1921 SPINNING_CUBE_GHOST;
	public static final class_1921 ICON_OVERLAY;
	public static final class_1921 BABYLON_ICON;
	public static final class_1921 MANA_POOL_WATER;
	public static final class_1921 TERRA_PLATE;
	public static final class_1921 ENCHANTER;
	public static final class_1921 HALO;
	public static final class_1921 MANA_PYLON_GLOW = getPylonGlow("mana_pylon_glow", RenderTilePylon.MANA_TEXTURE);
	public static final class_1921 NATURA_PYLON_GLOW = getPylonGlow("natura_pylon_glow", RenderTilePylon.NATURA_TEXTURE);
	public static final class_1921 GAIA_PYLON_GLOW = getPylonGlow("gaia_pylon_glow", RenderTilePylon.GAIA_TEXTURE);
	public static final class_1921 MANA_PYLON_GLOW_DIRECT = getPylonGlowDirect("mana_pylon_glow_direct", RenderTilePylon.MANA_TEXTURE);
	public static final class_1921 NATURA_PYLON_GLOW_DIRECT = getPylonGlowDirect("natura_pylon_glow_direct", RenderTilePylon.NATURA_TEXTURE);
	public static final class_1921 GAIA_PYLON_GLOW_DIRECT = getPylonGlowDirect("gaia_pylon_glow_direct", RenderTilePylon.GAIA_TEXTURE);

	public static final class_1921 ASTROLABE_PREVIEW;

	static {
		// todo 1.16 update to match vanilla where necessary (alternate render targets, etc.)
		class_4668.class_4685 lightningTransparency = AccessorRenderState.getLightningTransparency();
		class_4668.class_4683 mipmapBlockAtlasTexture = new class_4668.class_4683(class_1059.field_5275, false, true);
		class_4668.class_4671 disableCull = new class_4668.class_4671(false);
		class_4668.class_4675 viewOffsetZLayering = AccessorRenderState.getViewOffsetZLayer();
		class_4668.class_4686 colorMask = new class_4668.class_4686(true, false);
		class_4668.class_4681 smoothShade = new class_4668.class_4681(true);
		class_4668.class_4676 enableLightmap = new class_4668.class_4676(true);
		class_4668.class_4679 enableOverlay = new class_4668.class_4679(true);
		class_4668.class_4673 enableDiffuse = new class_4668.class_4673(true);
		class_4668.class_4669 oneTenthAlpha = new class_4668.class_4669(0.004F);
		class_4668.class_4672 noDepth = new class_4668.class_4672("always", GL11.GL_ALWAYS);
		class_4668.class_4678 itemTarget = AccessorRenderState.getItemEntityTarget();
		boolean useShaders = ShaderHelper.useShaders();

		class_1921.class_4688 glState = class_1921.class_4688.method_23598().method_23612(smoothShade)
				.method_23616(colorMask)
				.method_23615(lightningTransparency)
				.method_23617(false);
		STAR = class_1921.method_24049(LibResources.PREFIX_MOD + "star", class_290.field_1576, GL11.GL_TRIANGLES, 256, false, false, glState);

		glState = class_1921.class_4688.method_23598()
				.method_23615(TRANSLUCENT_TRANSPARENCY)
				.method_23610(itemTarget)
				.method_23603(disableCull).method_23617(false);
		RECTANGLE = class_1921.method_24049(LibResources.PREFIX_MOD + "rectangle_highlight", class_290.field_1576, GL11.GL_QUADS, 256, false, true, glState);
		CIRCLE = class_1921.method_24049(LibResources.PREFIX_MOD + "circle_highlight", class_290.field_1576, GL11.GL_TRIANGLES, 256, false, false, glState);

		glState = class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(1))).method_23607(viewOffsetZLayering).method_23615(TRANSLUCENT_TRANSPARENCY).method_23616(colorMask).method_23617(false);
		LINE_1 = class_1921.method_24048(LibResources.PREFIX_MOD + "line_1", class_290.field_1576, GL11.GL_LINES, 128, glState);
		glState = class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(1))).method_23607(viewOffsetZLayering).method_23615(TRANSLUCENT_TRANSPARENCY).method_23616(colorMask).method_23604(noDepth).method_23617(false);
		LINE_1_NO_DEPTH = class_1921.method_24048(LibResources.PREFIX_MOD + "line_1_no_depth", class_290.field_1576, GL11.GL_LINES, 128, glState);
		glState = class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(4))).method_23607(viewOffsetZLayering).method_23615(TRANSLUCENT_TRANSPARENCY).method_23616(colorMask).method_23604(noDepth).method_23617(false);
		LINE_4_NO_DEPTH = class_1921.method_24048(LibResources.PREFIX_MOD + "line_4_no_depth", class_290.field_1576, GL11.GL_LINES, 128, glState);
		glState = class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(5))).method_23607(viewOffsetZLayering).method_23615(TRANSLUCENT_TRANSPARENCY).method_23616(colorMask).method_23604(noDepth).method_23617(false);
		LINE_5_NO_DEPTH = class_1921.method_24048(LibResources.PREFIX_MOD + "line_5_no_depth", class_290.field_1576, GL11.GL_LINES, 64, glState);
		glState = class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(8))).method_23607(viewOffsetZLayering).method_23615(TRANSLUCENT_TRANSPARENCY).method_23616(colorMask).method_23604(noDepth).method_23617(false);
		LINE_8_NO_DEPTH = class_1921.method_24048(LibResources.PREFIX_MOD + "line_8_no_depth", class_290.field_1576, GL11.GL_LINES, 64, glState);

		glState = class_1921.class_4688.method_23598()
				.method_23613(mipmapBlockAtlasTexture)
				.method_23615(TRANSLUCENT_TRANSPARENCY)
				.method_23610(itemTarget)
				.method_23602(new class_4668.class_4669(0.05F))
				.method_23608(enableLightmap).method_23617(true);
		SPARK = class_1921.method_24048(LibResources.PREFIX_MOD + "spark", class_290.field_20888, GL11.GL_QUADS, 256, glState);
		class_1921 lightRelay = class_1921.method_24048(LibResources.PREFIX_MOD + "light_relay", class_290.field_20888, GL11.GL_QUADS, 64, glState);
		LIGHT_RELAY = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.HALO, null, lightRelay) : lightRelay;

		glState = class_1921.class_4688.method_23598().method_23613(new class_4668.class_4683()).method_23605(enableDiffuse).method_23617(false);
		SPINNING_CUBE = class_1921.method_24048(LibResources.PREFIX_MOD + "spinning_cube", class_290.field_1580, GL11.GL_QUADS, 64, glState);

		glState = class_1921.class_4688.method_23598()
				.method_23613(new class_4668.class_4683())
				.method_23605(enableDiffuse)
				.method_23615(TRANSLUCENT_TRANSPARENCY)
				.method_23610(itemTarget)
				.method_23617(false);
		SPINNING_CUBE_GHOST = class_1921.method_24048(LibResources.PREFIX_MOD + "spinning_cube_ghost", class_290.field_1580, GL11.GL_QUADS, 64, glState);

		glState = class_1921.class_4688.method_23598().method_23613(mipmapBlockAtlasTexture)
				.method_23615(TRANSLUCENT_TRANSPARENCY)
				.method_23610(itemTarget)
				.method_23605(new class_4668.class_4673(true))
				.method_23602(oneTenthAlpha)
				.method_23608(enableLightmap).method_23617(true);
		ICON_OVERLAY = class_1921.method_24048(LibResources.PREFIX_MOD + "icon_overlay", class_290.field_20888, GL11.GL_QUADS, 128, glState);

		class_4668.class_4683 babylonTexture = new class_4668.class_4683(new class_2960(LibResources.MISC_BABYLON), false, true);
		glState = class_1921.class_4688.method_23598().method_23613(babylonTexture)
				.method_23615(TRANSLUCENT_TRANSPARENCY)
				.method_23610(itemTarget)
				.method_23603(disableCull)
				.method_23612(smoothShade).method_23617(true);
		class_1921 babylonIcon = class_1921.method_24048(LibResources.PREFIX_MOD + "babylon", class_290.field_20887, GL11.GL_QUADS, 64, glState);
		BABYLON_ICON = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.HALO, null, babylonIcon) : babylonIcon;

		MANA_POOL_WATER = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.MANA_POOL, null, ICON_OVERLAY) : ICON_OVERLAY;
		TERRA_PLATE = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.TERRA_PLATE, null, ICON_OVERLAY) : ICON_OVERLAY;
		ENCHANTER = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.ENCHANTER_RUNE, null, ICON_OVERLAY) : ICON_OVERLAY;

		class_4668.class_4683 haloTexture = new class_4668.class_4683(ItemFlightTiara.textureHalo, false, true);
		glState = class_1921.class_4688.method_23598().method_23613(haloTexture)
				.method_23615(TRANSLUCENT_TRANSPARENCY)
				.method_23605(new class_4668.class_4673(true))
				.method_23602(oneTenthAlpha)
				.method_23603(disableCull)
				.method_23617(true);
		class_1921 halo = class_1921.method_24048(LibResources.PREFIX_MOD + "halo", class_290.field_1585, GL11.GL_QUADS, 64, glState);
		HALO = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.HALO, null, halo) : halo;

		// Same as entity_translucent, with no depth test and a shader
		glState = class_1921.class_4688.method_23598().method_23604(new class_4668.class_4672("always", GL11.GL_ALWAYS)).method_23613(new class_4668.class_4683(class_1059.field_5275, false, false)).method_23615(TRANSLUCENT_TRANSPARENCY).method_23605(enableDiffuse).method_23602(oneTenthAlpha).method_23603(disableCull).method_23608(enableLightmap).method_23611(enableOverlay).method_23617(true);
		ShaderCallback cb = shader -> {
			int alpha = class_4493.method_21990(shader, "alpha");
			ShaderHelper.FLOAT_BUF.position(0);
			ShaderHelper.FLOAT_BUF.put(0, 0.4F);
			RenderSystem.glUniform1(alpha, ShaderHelper.FLOAT_BUF);
		};
		class_1921 astrolabePreview = class_1921.method_24049(LibResources.PREFIX_MOD + "astrolabe_preview", class_290.field_1580, 7, 256, true, true, glState);
		ASTROLABE_PREVIEW = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.ALPHA, cb, astrolabePreview) : astrolabePreview;
	}

	private static class_1921 getPylonGlowDirect(String name, class_2960 texture) {
		return getPylonGlow(name, texture, true);
	}

	private static class_1921 getPylonGlow(String name, class_2960 texture) {
		return getPylonGlow(name, texture, false);
	}

	private static class_1921 getPylonGlow(String name, class_2960 texture, boolean direct) {
		class_1921.class_4688.class_4689 glState = class_1921.class_4688.method_23598()
				.method_23613(new class_4668.class_4683(texture, false, false))
				.method_23615(TRANSLUCENT_TRANSPARENCY)
				.method_23605(new class_4668.class_4673(true))
				.method_23602(new class_4668.class_4669(0))
				.method_23603(new class_4668.class_4671(false))
				.method_23608(new class_4668.class_4676(true));
		if (!direct) {
			glState = glState.method_23610(AccessorRenderState.getItemEntityTarget());
		}
		class_1921 layer = class_1921.method_24048(LibResources.PREFIX_MOD + name, class_290.field_1580, GL11.GL_QUADS, 128, glState.method_23617(false));
		return ShaderHelper.useShaders() ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.PYLON_GLOW, null, layer) : layer;
	}

	public static class_1921 getHaloLayer(class_2960 texture) {
		class_1921.class_4688 glState = class_1921.class_4688.method_23598()
				.method_23613(new class_4668.class_4683(texture, true, false))
				.method_23603(new class_4668.class_4671(false))
				.method_23615(TRANSLUCENT_TRANSPARENCY).method_23617(false);
		return class_1921.method_24049(LibResources.PREFIX_MOD + "crafting_halo", class_290.field_20887, GL11.GL_QUADS, 64, false, true, glState);
	}

	public static void drawTexturedModalRect(class_4587 ms, int x, int y, int u, int v, int width, int height) {
		class_332.method_25290(ms, x, y, u, v, width, height, 256, 256);
	}

	public static void renderStar(class_4587 ms, class_4597 buffers, int color, float xScale, float yScale, float zScale, long seed) {
		class_4588 buffer = buffers.getBuffer(STAR);

		float ticks = (ClientTickHandler.ticksInGame % 200) + ClientTickHandler.partialTicks;
		if (ticks >= 100) {
			ticks = 200 - ticks - 1;
		}

		float f1 = ticks / 200F;
		float f2 = f1 > 0.F ? (f1 - 0.7F) / 0.2F : 0;
		Random random = new Random(seed);

		ms.method_22903();
		ms.method_22905(xScale, yScale, zScale);

		for (int i = 0; i < (f1 + f1 * f1) / 2F * 90F + 30F; i++) {
			ms.method_22907(class_1160.field_20703.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20705.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20707.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20703.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20705.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20707.method_23214(random.nextFloat() * 360F + f1 * 90F));
			float f3 = random.nextFloat() * 20F + 5F + f2 * 10F;
			float f4 = random.nextFloat() * 2F + 1F + f2 * 2F;
			float r = ((color & 0xFF0000) >> 16) / 255F;
			float g = ((color & 0xFF00) >> 8) / 255F;
			float b = (color & 0xFF) / 255F;
			class_1159 mat = ms.method_23760().method_23761();
			Runnable center = () -> buffer.method_22918(mat, 0, 0, 0).method_22915(r, g, b, 1F - f2).method_1344();
			Runnable[] vertices = {
					() -> buffer.method_22918(mat, -0.866F * f4, f3, -0.5F * f4).method_1336(0, 0, 0, 0).method_1344(),
					() -> buffer.method_22918(mat, 0.866F * f4, f3, -0.5F * f4).method_1336(0, 0, 0, 0).method_1344(),
					() -> buffer.method_22918(mat, 0, f3, 1F * f4).method_1336(0, 0, 0, 0).method_1344(),
					() -> buffer.method_22918(mat, -0.866F * f4, f3, -0.5F * f4).method_1336(0, 0, 0, 0).method_1344()
			};
			triangleFan(center, vertices);
		}

		ms.method_22909();
	}

	public static void triangleFan(Runnable center, Runnable... vertices) {
		triangleFan(center, Arrays.asList(vertices));
	}

	/**
	 * With a buffer in GL_TRIANGLES mode, emulates GL_TRIANGLE_FAN on the CPU.
	 * This is because batching of GL_TRIANGLE_FAN makes no sense (the vertices would bleed into one massive fan)
	 */
	public static void triangleFan(Runnable center, List<Runnable> vertices) {
		for (int i = 0; i < vertices.size() - 1; i++) {
			center.run();
			vertices.get(i).run();
			vertices.get(i + 1).run();
		}
	}

	public static void renderProgressPie(class_4587 ms, int x, int y, float progress, class_1799 stack) {
		class_310 mc = class_310.method_1551();
		mc.method_1480().method_4023(stack, x, y);

		RenderSystem.clear(GL11.GL_DEPTH_BUFFER_BIT, true);
		GL11.glEnable(GL11.GL_STENCIL_TEST);
		RenderSystem.colorMask(false, false, false, false);
		RenderSystem.depthMask(false);
		RenderSystem.stencilFunc(GL11.GL_NEVER, 1, 0xFF);
		RenderSystem.stencilOp(GL11.GL_REPLACE, GL11.GL_KEEP, GL11.GL_KEEP);
		RenderSystem.stencilMask(0xFF);
		mc.method_1480().method_4023(stack, x, y);

		mc.method_1531().method_22813(new class_2960(LibResources.GUI_MANA_HUD));
		int r = 10;
		int centerX = x + 8;
		int centerY = y + 8;
		int degs = (int) (360 * progress);
		float a = 0.5F + 0.2F * ((float) Math.cos((double) (ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) / 10) * 0.5F + 0.5F);

		RenderSystem.disableLighting();
		RenderSystem.disableTexture();
		RenderSystem.shadeModel(GL11.GL_SMOOTH);
		RenderSystem.enableBlend();
		RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		RenderSystem.colorMask(true, true, true, true);
		RenderSystem.depthMask(true);
		RenderSystem.stencilMask(0x00);
		RenderSystem.stencilFunc(GL11.GL_EQUAL, 1, 0xFF);

		class_1159 mat = ms.method_23760().method_23761();
		class_287 buf = class_289.method_1348().method_1349();
		buf.method_1328(GL11.GL_TRIANGLE_FAN, class_290.field_1576);
		buf.method_22918(mat, centerX, centerY, 0).method_22915(0, 0.5F, 0.5F, a).method_1344();

		for (int i = degs; i > 0; i--) {
			float rad = (i - 90) / 180F * (float) Math.PI;
			buf.method_22918(mat, centerX + class_3532.method_15362(rad) * r, centerY + class_3532.method_15374(rad) * r, 0).method_22915(0F, 1F, 0.5F, a).method_1344();
		}

		buf.method_22918(mat, centerX, centerY, 0).method_22915(0F, 1F, 0.5F, a).method_1344();
		class_289.method_1348().method_1350();

		RenderSystem.disableBlend();
		RenderSystem.enableTexture();
		RenderSystem.shadeModel(GL11.GL_FLAT);
		GL11.glDisable(GL11.GL_STENCIL_TEST);
	}

	/**
	 * @param color Must include alpha
	 */
	// [VanillaCopy] ItemRenderer.renderItem with simplifications + color support + custom model
	public static void renderItemCustomColor(class_1309 entity, class_1799 stack, int color, class_4587 ms, class_4597 buffers, int light, int overlay, @Nullable class_1087 model) {
		ms.method_22903();
		if (model == null) {
			model = class_310.method_1551().method_1480().method_4019(stack, entity.field_6002, entity);
		}
		model.method_4709().method_3503(class_809.class_811.field_4315).method_23075(false, ms);
		ms.method_22904(-0.5D, -0.5D, -0.5D);

		if (!model.method_4713() && (stack.method_7909() != class_1802.field_8547)) {
			class_1921 rendertype = class_4696.method_23678(stack, true);
			class_4588 ivertexbuilder = class_918.method_29711(buffers, rendertype, true, stack.method_7958());
			renderBakedItemModel(model, stack, color, light, overlay, ms, ivertexbuilder);
		} else {
			class_756.field_3986.method_3166(stack, class_809.class_811.field_4315, ms, buffers, light, overlay);
		}

		ms.method_22909();
	}

	public static void renderItemCustomColor(class_1309 entity, class_1799 stack, int color, class_4587 ms, class_4597 buffers, int light, int overlay) {
		renderItemCustomColor(entity, stack, color, ms, buffers, light, overlay, null);
	}

	// [VanillaCopy] ItemRenderer with custom color
	private static void renderBakedItemModel(class_1087 model, class_1799 stack, int color, int light, int overlay, class_4587 ms, class_4588 buffer) {
		Random random = new Random();
		long i = 42L;

		for (class_2350 direction : class_2350.values()) {
			random.setSeed(42L);
			renderBakedItemQuads(ms, buffer, color, model.method_4707((class_2680) null, direction, random), stack, light, overlay);
		}

		random.setSeed(42L);
		renderBakedItemQuads(ms, buffer, color, model.method_4707((class_2680) null, (class_2350) null, random), stack, light, overlay);
	}

	// [VanillaCopy] ItemRenderer, with custom color + alpha support
	private static void renderBakedItemQuads(class_4587 ms, class_4588 buffer, int color, List<class_777> quads, class_1799 stack, int light, int overlay) {
		class_4587.class_4665 matrixstack$entry = ms.method_23760();

		for (class_777 bakedquad : quads) {
			int i = color;

			float f = (float) (i >> 16 & 255) / 255.0F;
			float f1 = (float) (i >> 8 & 255) / 255.0F;
			float f2 = (float) (i & 255) / 255.0F;
			float alpha = ((color >> 24) & 0xFF) / 255.0F;
			// todo 1.16-fabric buffer.addVertexData(matrixstack$entry, bakedquad, f, f1, f2, alpha, light, overlay, true);
		}

	}
}
