/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.mixin.AccessorFirstPersonRenderer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1059;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_557;
import net.minecraft.class_742;

// Hacky way to render 3D lexicon, will be reevaluated in the future.
public class RenderLexicon {
	private static final class_557 model = new class_557();
	private static final boolean SHOULD_MISSPELL = Math.random() < 0.004;
	public static final class_4730 TEXTURE = new class_4730(class_1059.field_5275, new class_2960(LibResources.MODEL_LEXICA_DEFAULT));
	public static final class_4730 ELVEN_TEXTURE = new class_4730(class_1059.field_5275, new class_2960(LibResources.MODEL_LEXICA_ELVEN));

	private static final String[] QUOTES = new String[] {
			"\"Neat!\" - Direwolf20",
			"\"It's pretty ledge.\" - Haighyorkie",
			"\"I don't really like it.\" - CrustyMustard",
			"\"It's a very thinky mod.\" - AdamG3691",
			"\"You must craft the tiny potato.\" - TheFractangle",
			"\"Vazkii did a thing.\" - cpw"
	};

	private static final String[] MISSPELLINGS = {
			"Bonito", "Bonita", "Bonitia", "Botnaia", "Bontonio",
			"Botnia", "Bonitaaaaaaaaaa", "Botonio", "Botonia",
			"Banana", "Brotania", "Botanica", "Boat", "Batania", "Bosnia"
	};

	private static int quote = -1;
	private static int misspelling = -1;

	/* todo 1.16-fabric
	public static void renderHand(RenderHandEvent evt) {
		MinecraftClient mc = MinecraftClient.getInstance();
		if (!ConfigHandler.CLIENT.lexicon3dModel.getValue()
				|| mc.options.perspective != 0
				|| mc.player.getStackInHand(evt.getHand()).isEmpty()
				|| mc.player.getStackInHand(evt.getHand()).getItem() != ModItems.lexicon) {
			return;
		}
		evt.setCanceled(true);
		try {
			renderFirstPersonItem(mc.player, evt.getPartialTicks(), evt.getInterpolatedPitch(), evt.getHand(), evt.getSwingProgress(), evt.getItemStack(), evt.getEquipProgress(), evt.getMatrixStack(), evt.getBuffers(), evt.getLight());
		} catch (Throwable throwable) {
			Botania.LOGGER.warn("Failed to render lexicon", throwable);
		}
	}
	*/

	// [VanillaCopy] FirstPersonRenderer, irrelevant branches stripped out
	private static void renderFirstPersonItem(class_742 player, float partialTicks, float pitch, class_1268 hand, float swingProgress, class_1799 stack, float equipProgress, class_4587 ms, class_4597 buffers, int light) {
		boolean flag = hand == class_1268.field_5808;
		class_1306 handside = flag ? player.method_6068() : player.method_6068().method_5928();
		ms.method_22903();
		{
			boolean flag3 = handside == class_1306.field_6183;
			{
				float f5 = -0.4F * class_3532.method_15374(class_3532.method_15355(swingProgress) * (float) Math.PI);
				float f6 = 0.2F * class_3532.method_15374(class_3532.method_15355(swingProgress) * ((float) Math.PI * 2F));
				float f10 = -0.2F * class_3532.method_15374(swingProgress * (float) Math.PI);
				int l = flag3 ? 1 : -1;
				ms.method_22904((double) ((float) l * f5), (double) f6, (double) f10);
				((AccessorFirstPersonRenderer) class_310.method_1551().method_1489()).botania_equipOffset(ms, handside, equipProgress);
				((AccessorFirstPersonRenderer) class_310.method_1551().method_1489()).botania_swingOffset(ms, handside, swingProgress);
			}

			doRender(stack, handside, ms, buffers, light, partialTicks);
		}

		ms.method_22909();
	}

	private static void doRender(class_1799 stack, class_1306 side, class_4587 ms, class_4597 buffers, int light, float partialTicks) {
		class_310 mc = class_310.method_1551();

		ms.method_22903();

		float ticks = ClientTickHandler.ticksWithLexicaOpen;
		if (ticks > 0 && ticks < 10) {
			if (ItemLexicon.isOpen()) {
				ticks += partialTicks;
			} else {
				ticks -= partialTicks;
			}
		}

		if (side == class_1306.field_6183) {
			ms.method_22904(0.3F + 0.02F * ticks, 0.125F + 0.01F * ticks, -0.2F - 0.035F * ticks);
			ms.method_22907(class_1160.field_20705.method_23214(180F + ticks * 6));
		} else {
			ms.method_22904(0.1F - 0.02F * ticks, 0.125F + 0.01F * ticks, -0.2F - 0.035F * ticks);
			ms.method_22907(class_1160.field_20705.method_23214(200F + ticks * 10));
		}
		ms.method_22907(class_1160.field_20707.method_23214(-0.3F + ticks * 2.85F));
		float opening = class_3532.method_15363(ticks / 12F, 0, 1);

		float pageFlipTicks = ClientTickHandler.pageFlipTicks;
		if (pageFlipTicks > 0) {
			pageFlipTicks -= ClientTickHandler.partialTicks;
		}

		float pageFlip = pageFlipTicks / 5F;

		float leftPageAngle = class_3532.method_22450(pageFlip + 0.25F) * 1.6F - 0.3F;
		float rightPageAngle = class_3532.method_22450(pageFlip + 0.75F) * 1.6F - 0.3F;
		model.method_17073(ClientTickHandler.total, class_3532.method_15363(leftPageAngle, 0.0F, 1.0F), class_3532.method_15363(rightPageAngle, 0.0F, 1.0F), opening);

		class_4730 mat = ModItems.lexicon.isElvenItem(stack) ? ELVEN_TEXTURE : TEXTURE;
		class_4588 buffer = mat.method_24145(buffers, class_1921::method_23572);
		model.method_2828(ms, buffer, light, class_4608.field_21444, 1, 1, 1, 1);

		if (ticks < 3) {
			class_327 font = class_310.method_1551().field_1772;
			ms.method_22907(class_1160.field_20707.method_23214(180F));
			ms.method_22904(-0.30F, -0.24F, -0.07F);
			ms.method_22905(0.0030F, 0.0030F, -0.0030F);

			if (misspelling == -1) {
				misspelling = mc.field_1687.field_9229.nextInt(MISSPELLINGS.length);
			}

			String title = ItemLexicon.getTitle(stack).getString();
			if (SHOULD_MISSPELL) {
				title = title.replaceAll(LibMisc.MOD_NAME, MISSPELLINGS[misspelling]);
			}
			font.method_27521(font.method_27523(title, 80), 0, 0, 0xD69700, false, ms.method_23760().method_23761(), buffers, false, 0, light);

			ms.method_22904(0F, 10F, 0F);
			ms.method_22905(0.6F, 0.6F, 0.6F);
			class_2561 edition = ItemLexicon.getEdition().method_27661().method_27695(class_124.field_1056, class_124.field_1067);
			font.method_30882(edition, 0, 0, 0xA07100, false, ms.method_23760().method_23761(), buffers, false, 0, light);

			if (quote == -1) {
				quote = mc.field_1687.field_9229.nextInt(QUOTES.length);
			}

			String quoteStr = QUOTES[quote];

			ms.method_22904(-5F, 15F, 0F);
			renderText(0, 0, 140, 100, 0, 0x79ff92, quoteStr, ms.method_23760().method_23761(), buffers, light);

			ms.method_22904(8F, 110F, 0F);
			String blurb = class_1074.method_4662("botaniamisc.lexiconcover0");
			font.method_27521(blurb, 0, 0, 0x79ff92, false, ms.method_23760().method_23761(), buffers, false, 0, light);

			ms.method_22904(0F, 10F, 0F);
			String blurb2 = class_124.field_1073 + "" + class_124.field_1056 + class_1074.method_4662("botaniamisc.lexiconcover1");
			font.method_27521(blurb2, 0, 0, 0x79ff92, false, ms.method_23760().method_23761(), buffers, false, 0, light);

			ms.method_22904(0F, -30F, 0F);

			String authorTitle = class_1074.method_4662("botaniamisc.lexiconcover2");
			int len = font.method_1727(authorTitle);
			font.method_27521(authorTitle, 58 - len / 2F, -8, 0xD69700, false, ms.method_23760().method_23761(), buffers, false, 0, light);
		}

		ms.method_22909();
	}

	private static void renderText(int x, int y, int width, int height, int paragraphSize, int color, String unlocalizedText, class_1159 matrix, class_4597 buffers, int light) {
		x += 2;
		y += 10;
		width -= 4;

		class_327 font = class_310.method_1551().field_1772;
		String text = class_1074.method_4662(unlocalizedText).replaceAll("&", "\u00a7");
		String[] textEntries = text.split("<br>");

		List<List<String>> lines = new ArrayList<>();

		String controlCodes;
		for (String s : textEntries) {
			List<String> words = new ArrayList<>();
			String lineStr = "";
			String[] tokens = s.split(" ");
			for (String token : tokens) {
				String prev = lineStr;
				String spaced = token + " ";
				lineStr += spaced;

				controlCodes = toControlCodes(getControlCodes(prev));
				if (font.method_1727(lineStr) > width) {
					lines.add(words);
					lineStr = controlCodes + spaced;
					words = new ArrayList<>();
				}

				words.add(controlCodes + token);
			}

			if (!lineStr.isEmpty()) {
				lines.add(words);
			}
			lines.add(new ArrayList<>());
		}

		int i = 0;
		for (List<String> words : lines) {
			int xi = x;
			int spacing = 4;

			for (String s : words) {
				int extra = 0;
				font.method_27521(s, xi, y, color, false, matrix, buffers, false, 0, light);
				xi += font.method_1727(s) + spacing + extra;
			}

			y += words.isEmpty() ? paragraphSize : 10;
			i++;
		}
	}

	private static String getControlCodes(String s) {
		String controls = s.replaceAll("(?<!\u00a7)(.)", "");
		return controls.replaceAll(".*r", "r");
	}

	private static String toControlCodes(String s) {
		return s.replaceAll(".", "\u00a7$0");
	}
}
