/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import vazkii.botania.common.Botania;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_310;

public final class PersistentVariableHelper {

	private static final String TAG_FIRST_LOAD = "firstLoad";
	private static final String TAG_DOG = "dog";

	private static File cacheFile;

	public static boolean firstLoad = true;
	public static boolean dog = true;

	public static void save() {
		class_2487 cmp = new class_2487();
		cmp.method_10556(TAG_FIRST_LOAD, firstLoad);
		cmp.method_10556(TAG_DOG, dog);

		injectNBTToFile(cmp, cacheFile);
	}

	public static void load() {
		class_2487 cmp = getCacheCompound(cacheFile);

		firstLoad = cmp.method_10545(TAG_FIRST_LOAD) ? cmp.method_10577(TAG_FIRST_LOAD) : firstLoad;
		dog = cmp.method_10577(TAG_DOG);
	}

	public static void init() {
		cacheFile = new File(class_310.method_1551().field_1697, "BotaniaVars.dat");
		try {
			cacheFile.createNewFile();
		} catch (IOException e) {
			Botania.LOGGER.error("Failed to create persistent variable file", e);
		}
		load();
	}

	private static class_2487 getCacheCompound(File cache) {
		try {
			return class_2507.method_10629(new FileInputStream(cache));
		} catch (IOException e) {
			Botania.LOGGER.error("Failed to load persistent variables, overwriting with current state", e);
			save();
			return new class_2487();
		}
	}

	private static void injectNBTToFile(class_2487 cmp, File f) {
		try {
			class_2507.method_10634(cmp, new FileOutputStream(f));
		} catch (IOException e) {
			Botania.LOGGER.error("Failed to save persistent variables", e);
		}
	}

}
