/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import vazkii.botania.client.model.GunModel;
import vazkii.botania.client.model.LexiconModel;
import vazkii.botania.client.model.PlatformModel;
import vazkii.botania.client.render.tile.RenderTileCorporeaCrystalCube;
import vazkii.botania.client.render.tile.RenderTilePump;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.relic.ItemKingKey;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.mixin.AccessorItemOverrideList;
import vazkii.botania.mixin.AccessorModelBakery;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4722;
import net.minecraft.class_4730;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class MiscellaneousIcons {
	public static final MiscellaneousIcons INSTANCE = new MiscellaneousIcons();

	public final class_4730 alfPortalTex = mainAtlas("block/alfheim_portal_swirl");
	public final class_4730 lightRelayWorldIcon = mainAtlas("block/light_relay");
	public final class_4730 lightRelayDetectorWorldIcon = mainAtlas("block/detector_light_relay");
	public final class_4730 lightRelayForkWorldIcon = mainAtlas("block/fork_light_relay");
	public final class_4730 lightRelayToggleWorldIcon = mainAtlas("block/toggle_light_relay");
	public final class_4730 alchemyCatalystOverlay = mainAtlas("block/alchemy_catalyst_overlay");
	public final class_4730 conjurationCatalystOverlay = mainAtlas("block/conjuration_catalyst_overlay");
	public final class_4730 enchanterOverlay = mainAtlas("block/enchanter_overlay");
	public final class_4730 manaVoidOverlay = mainAtlas("block/mana_void_overlay");
	public final class_4730 manaWater = mainAtlas("block/mana_water");
	public final class_4730 terraPlateOverlay = mainAtlas("block/terra_plate_overlay");
	public final class_4730 corporeaWorldIcon = mainAtlas("item/corporea_spark");
	public final class_4730 corporeaWorldIconMaster = mainAtlas("item/corporea_spark_master");
	public final class_4730 corporeaIconStar = mainAtlas("item/corporea_spark_star");
	public final class_4730 sparkWorldIcon = mainAtlas("item/spark");

	public final class_4730[] sparkUpgradeIcons = new class_4730[] {
			mainAtlas("item/spark_upgrade_rune_dispersive"),
			mainAtlas("item/spark_upgrade_rune_dominant"),
			mainAtlas("item/spark_upgrade_rune_recessive"),
			mainAtlas("item/spark_upgrade_rune_isolated")
	};
	public final class_1087[] tiaraWingIcons = new class_1087[ItemFlightTiara.WING_TYPES];
	public final class_1087[] thirdEyeLayers = new class_1087[3];

	public class_1087 goldfishModel,
			phiFlowerModel,
			nerfBatModel,
			bloodPendantChain,
			bloodPendantGem,
			snowflakePendantGem,
			itemFinderGem,
			pyroclastGem,
			crimsonGem,
			cirrusGem,
			nimbusGem,
			terrasteelHelmWillModel,
			elvenSpreaderInside,
			gaiaSpreaderInside,
			manaSpreaderInside,
			redstoneSpreaderInside;

	public final class_1087[] kingKeyWeaponModels = new class_1087[ItemKingKey.WEAPON_TYPES];

	public void onModelRegister(class_3300 rm, Consumer<class_2960> consumer) {
		Set<class_4730> materials = AccessorModelBakery.getMaterials();

		materials.addAll(Arrays.asList(alfPortalTex, lightRelayWorldIcon, lightRelayDetectorWorldIcon,
				lightRelayForkWorldIcon, lightRelayToggleWorldIcon, alchemyCatalystOverlay, conjurationCatalystOverlay,
				enchanterOverlay, manaVoidOverlay, manaWater, terraPlateOverlay, corporeaWorldIcon, corporeaWorldIconMaster,
				corporeaIconStar, sparkWorldIcon));
		materials.addAll(Arrays.asList(sparkUpgradeIcons));
		materials.add(RenderLexicon.TEXTURE);
		materials.add(RenderLexicon.ELVEN_TEXTURE);
		for (class_2582 pattern : class_2582.values()) {
			if (pattern.method_10947().startsWith(LibMisc.MOD_ID)) {
				materials.add(new class_4730(class_4722.field_21707, pattern.method_22536(false)));
				materials.add(new class_4730(class_4722.field_21706, pattern.method_22536(true)));
			}
		}
		consumer.accept(prefix("icon/goldfish"));
		consumer.accept(prefix("icon/phiflower"));
		consumer.accept(prefix("icon/nerfbat"));
		consumer.accept(prefix("icon/blood_pendant_chain"));
		consumer.accept(prefix("icon/blood_pendant_gem"));
		for (int i = 0; i < ItemKingKey.WEAPON_TYPES; i++) {
			consumer.accept(prefix("icon/gate_weapon_" + i));
		}
		consumer.accept(prefix("icon/will_flame"));
		for (int i = 0; i < thirdEyeLayers.length; i++) {
			consumer.accept(prefix("icon/third_eye_" + i));
		}
		consumer.accept(prefix("icon/lava_pendant_gem"));
		consumer.accept(prefix("icon/super_lava_pendant_gem"));
		consumer.accept(prefix("icon/itemfinder_gem"));
		consumer.accept(prefix("icon/cloud_pendant_gem"));
		consumer.accept(prefix("icon/super_cloud_pendant_gem"));
		consumer.accept(prefix("icon/ice_pendant_gem"));
		for (int i = 0; i < tiaraWingIcons.length; i++) {
			consumer.accept(prefix("icon/tiara_wing_" + (i + 1)));
		}
	}

	public void onModelBake(class_1088 loader, Map<class_2960, class_1087> map) {
		if (!ModelHandler.registeredModels) {
			Botania.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
			return;
		}
		// Platforms
		class_1091 abstruseName = new class_1091("botania:abstruse_platform", "");
		class_1087 abstruse = map.get(abstruseName);
		class_1091 spectralName = new class_1091("botania:spectral_platform", "");
		class_1087 spectral = map.get(spectralName);
		class_1091 infrangibleName = new class_1091("botania:infrangible_platform", "");
		class_1087 infrangible = map.get(infrangibleName);

		map.put(abstruseName, new PlatformModel(abstruse));
		map.put(spectralName, new PlatformModel(spectral));
		map.put(infrangibleName, new PlatformModel(infrangible));

		// Lexicon
		class_1087 original = map.get(new class_1091("botania:lexicon", "inventory"));
		map.put(new class_1091("botania:lexicon", "inventory"),
				new LexiconModel(original));

		// models referenced using json overrides aren't put in the model registry, so just go through all override models and wrap them there
		List<class_1087> overrides = ((AccessorItemOverrideList) original.method_4710()).getModels();
		for (int i = 0; i < overrides.size(); i++) {
			overrides.set(i, new LexiconModel(overrides.get(i)));
		}

		// Mana Blaster
		class_1091 key = new class_1091("botania:mana_gun", "inventory");
		class_1087 originalModel = map.get(key);
		class_1091 clipKey = new class_1091("botania:mana_gun_clip", "inventory");
		class_1087 originalModelClip = map.get(clipKey);
		map.put(key, new GunModel(loader, originalModel, originalModelClip));

		// todo 1.16-fabric remove OrDefault when williewillus/botania-fabric-issues#15 is fixed
		class_1087 missing = map.get(class_1088.field_5374);
		RenderTileCorporeaCrystalCube.cubeModel = map.getOrDefault(prefix("block/corporea_crystal_cube_glass"), missing);
		RenderTilePump.headModel = map.getOrDefault(prefix("block/pump_head"), missing);
		elvenSpreaderInside = map.getOrDefault(prefix("block/elven_spreader_inside"), missing);
		gaiaSpreaderInside = map.getOrDefault(prefix("block/gaia_spreader_inside"), missing);
		manaSpreaderInside = map.getOrDefault(prefix("block/mana_spreader_inside"), missing);
		redstoneSpreaderInside = map.getOrDefault(prefix("block/redstone_spreader_inside"), missing);

		// Icons
		goldfishModel = map.getOrDefault(prefix("icon/goldfish"), missing);
		phiFlowerModel = map.getOrDefault(prefix("icon/phiflower"), missing);
		nerfBatModel = map.getOrDefault(prefix("icon/nerfbat"), missing);
		bloodPendantChain = map.getOrDefault(prefix("icon/blood_pendant_chain"), missing);
		bloodPendantGem = map.getOrDefault(prefix("icon/blood_pendant_gem"), missing);
		for (int i = 0; i < ItemKingKey.WEAPON_TYPES; i++) {
			kingKeyWeaponModels[i] = map.getOrDefault(prefix("icon/gate_weapon_" + i), missing);
		}
		terrasteelHelmWillModel = map.getOrDefault(prefix("icon/will_flame"), missing);
		for (int i = 0; i < thirdEyeLayers.length; i++) {
			thirdEyeLayers[i] = map.getOrDefault(prefix("icon/third_eye_" + i), missing);
		}
		pyroclastGem = map.getOrDefault(prefix("icon/lava_pendant_gem"), missing);
		crimsonGem = map.getOrDefault(prefix("icon/super_lava_pendant_gem"), missing);
		itemFinderGem = map.getOrDefault(prefix("icon/itemfinder_gem"), missing);

		cirrusGem = map.getOrDefault(prefix("icon/cloud_pendant_gem"), missing);
		nimbusGem = map.getOrDefault(prefix("icon/super_cloud_pendant_gem"), missing);
		snowflakePendantGem = map.getOrDefault(prefix("icon/ice_pendant_gem"), missing);
		for (int i = 0; i < tiaraWingIcons.length; i++) {
			tiaraWingIcons[i] = map.getOrDefault(prefix("icon/tiara_wing_" + (i + 1)), missing);
		}
	}

	private static class_4730 mainAtlas(String name) {
		return new class_4730(class_1059.field_5275, prefix(name));
	}

	private MiscellaneousIcons() {}
}
