/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;
import net.minecraft.class_1160;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_809;

public final class ManaTabletRenderHandler extends class_3887<class_742, class_591<class_742>> {

	public ManaTabletRenderHandler(class_3883<class_742, class_591<class_742>> renderer) {
		super(renderer);
	}

	@Override
	public void render(class_4587 ms, class_4597 buffers, int light, @Nonnull class_742 player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		if (ConfigHandler.CLIENT.renderAccessories.getValue() && !player.method_5767()) {
			renderManaTablet(ms, buffers, player);
		}
	}

	private void renderManaTablet(class_4587 ms, class_4597 buffers, class_1657 player) {
		boolean renderedOne = false;
		for (int i = 0; i < player.field_7514.method_5439(); i++) {
			class_1799 stack = player.field_7514.method_5438(i);
			if (!stack.method_7960() && stack.method_7909() == ModItems.manaTablet) {
				ms.method_22903();
				boolean armor = !player.method_6118(class_1304.field_6172).method_7960();

				method_17165().field_3391.method_22703(ms);
				ms.method_22904(0, 0.65, 0);
				if (renderedOne) {
					ms.method_22904(armor ? 0.3 : 0.25, 0, 0);
					ms.method_22907(class_1160.field_20705.method_23214(-90F));
				} else {
					ms.method_22904(armor ? -0.3 : -0.25, 0, 0);
					ms.method_22907(class_1160.field_20705.method_23214(90F));
				}

				ms.method_22905(0.375F, -0.375F, -0.375F);
				class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4315, 0xF000F0, class_4608.field_21444, ms, buffers);
				ms.method_22909();

				if (renderedOne) {
					return;
				}
				renderedOne = true;
			}
		}
	}
}
