/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.opengl.GL11;

import vazkii.botania.client.fx.FXLightning;
import vazkii.botania.client.lib.LibResources;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;

public class LightningHandler {

	private LightningHandler() {}

	private static final int BATCH_THRESHOLD = 200;
	private static final class_2960 outsideResource = new class_2960(LibResources.MISC_WISP_LARGE);
	private static final class_2960 insideResource = new class_2960(LibResources.MISC_WISP_SMALL);
	public static final Deque<FXLightning> queuedLightningBolts = new ArrayDeque<>();

	public static void onRenderWorldLast(float frame, class_4587 ms) {
		class_3695 profiler = class_310.method_1551().method_16011();

		profiler.method_15396("botania-particles");
		profiler.method_15396("lightning");

		class_1297 entity = class_310.method_1551().field_1724;
		class_1060 render = class_310.method_1551().method_1531();

		double interpPosX = entity.field_6038 + (entity.method_23317() - entity.field_6038) * frame;
		double interpPosY = entity.field_5971 + (entity.method_23318() - entity.field_5971) * frame;
		double interpPosZ = entity.field_5989 + (entity.method_23321() - entity.field_5989) * frame;

		ms.method_22903();
		ms.method_22904(-interpPosX, -interpPosY, -interpPosZ);

		class_289 tessellator = class_289.method_1348();

		RenderSystem.depthMask(false);
		RenderSystem.enableBlend();
		RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

		render.method_22813(outsideResource);
		int counter = 0;

		tessellator.method_1349().method_1328(GL11.GL_QUADS, class_290.field_20888);
		for (FXLightning bolt : queuedLightningBolts) {
			bolt.renderBolt(ms, tessellator.method_1349(), 0, false);
			if (counter % BATCH_THRESHOLD == BATCH_THRESHOLD - 1) {
				tessellator.method_1350();
				tessellator.method_1349().method_1328(GL11.GL_QUADS, class_290.field_20888);
			}
			counter++;
		}
		tessellator.method_1350();

		render.method_22813(insideResource);
		counter = 0;

		tessellator.method_1349().method_1328(GL11.GL_QUADS, class_290.field_20888);
		for (FXLightning bolt : queuedLightningBolts) {
			bolt.renderBolt(ms, tessellator.method_1349(), 1, true);
			if (counter % BATCH_THRESHOLD == BATCH_THRESHOLD - 1) {
				tessellator.method_1350();
				tessellator.method_1349().method_1328(GL11.GL_QUADS, class_290.field_20888);
			}
			counter++;
		}
		tessellator.method_1350();

		queuedLightningBolts.clear();

		RenderSystem.disableBlend();
		RenderSystem.depthMask(true);

		ms.method_22909();

		profiler.method_15407();
		profiler.method_15407();

	}
}
