/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.glfw.GLFW;

import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ItemLexicon;

public class KonamiHandler {
	private static final int[] KONAMI_CODE = {
			GLFW.GLFW_KEY_UP, GLFW.GLFW_KEY_UP,
			GLFW.GLFW_KEY_DOWN, GLFW.GLFW_KEY_DOWN,
			GLFW.GLFW_KEY_LEFT, GLFW.GLFW_KEY_RIGHT,
			GLFW.GLFW_KEY_LEFT, GLFW.GLFW_KEY_RIGHT,
			GLFW.GLFW_KEY_B, GLFW.GLFW_KEY_A,
	};
	private static int nextLetter = 0;
	private static int konamiTime = 0;

	public static void clientTick(class_310 client) {
		if (konamiTime > 0) {
			konamiTime--;
		}

		if (!ItemLexicon.isOpen()) {
			nextLetter = 0;
		}
	}

	public static void handleInput(int key, int action, int modifiers) {
		class_310 mc = class_310.method_1551();
		if (modifiers == 0 && action == GLFW.GLFW_PRESS && ItemLexicon.isOpen()) {
			if (konamiTime == 0 && key == KONAMI_CODE[nextLetter]) {
				nextLetter++;
				if (nextLetter >= KONAMI_CODE.length) {
					mc.method_1483().method_4873(class_1109.method_4758(ModSounds.way, 1.0F));
					nextLetter = 0;
					konamiTime = 240;
				}
			} else {
				nextLetter = 0;
			}
		}
	}

	public static void renderBook(class_2960 book, class_437 gui, int mouseX, int mouseY, float partialTicks, class_4587 ms) {
		if (konamiTime > 0) {
			String meme = class_1074.method_4662("botania.subtitle.way");
			RenderSystem.disableDepthTest();
			ms.method_22903();
			int fullWidth = class_310.method_1551().field_1772.method_1727(meme);
			int left = gui.field_22789;
			double widthPerTick = (fullWidth + gui.field_22789) / 240;
			double currWidth = left - widthPerTick * (240 - (konamiTime - partialTicks)) * 3.2;

			ms.method_22904(currWidth, gui.field_22790 / 2 - 10, 0);
			ms.method_22905(4, 4, 4);
			class_310.method_1551().field_1772.method_1720(ms, meme, 0, 0, 0xFFFFFF);
			ms.method_22909();
			RenderSystem.enableDepthTest();
		}
	}
}
