/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.common.network.PacketUpdateItemsRemaining;

import javax.annotation.Nullable;

import java.util.regex.Pattern;

public final class ItemsRemainingRenderHandler {

	private static final int maxTicks = 30;
	private static final int leaveTicks = 20;

	private static class_1799 stack = class_1799.field_8037;
	@Nullable
	private static class_2561 customString;
	private static int ticks, count;

	@Environment(EnvType.CLIENT)
	public static void render(class_4587 ms, float partTicks) {
		if (ticks > 0 && !stack.method_7960()) {
			int pos = maxTicks - ticks;
			class_310 mc = class_310.method_1551();
			int x = mc.method_22683().method_4486() / 2 + 10 + Math.max(0, pos - leaveTicks);
			int y = mc.method_22683().method_4502() / 2;

			int start = maxTicks - leaveTicks;
			float alpha = ticks + partTicks > start ? 1F : (ticks + partTicks) / start;

			// RenderSystem.color4f(1F, 1F, 1F, alpha);
			int xp = x + (int) (16F * (1F - alpha));
			ms.method_22903();
			ms.method_22904(xp, y, 0F);
			ms.method_22905(alpha, 1F, 1F);
			RenderSystem.pushMatrix();
			RenderSystem.multMatrix(ms.method_23760().method_23761());
			mc.method_1480().method_4023(stack, 0, 0);
			RenderSystem.popMatrix();
			ms.method_22909();

			class_2561 text = class_2585.field_24366;

			if (customString == null) {
				if (!stack.method_7960()) {
					text = stack.method_7964().method_27661().method_27692(class_124.field_1060);
					if (count >= 0) {
						int max = stack.method_7914();
						int stacks = count / max;
						int rem = count % max;

						if (stacks == 0) {
							text = new class_2585(Integer.toString(count));
						} else {
							class_2561 stacksText = new class_2585(Integer.toString(stacks)).method_27692(class_124.field_1075);
							class_2561 maxText = new class_2585(Integer.toString(max)).method_27692(class_124.field_1080);
							class_2561 remText = new class_2585(Integer.toString(rem)).method_27692(class_124.field_1054);
							text = new class_2585(count + " (")
									.method_10852(stacksText)
									.method_27693("*")
									.method_10852(maxText)
									.method_27693("+")
									.method_10852(remText)
									.method_27693(")");
						}
					} else if (count == -1) {
						text = new class_2585("\u221E");
					}
				}
			} else {
				text = customString;
			}

			int color = 0x00FFFFFF | (int) (alpha * 0xFF) << 24;
			mc.field_1772.method_30881(ms, text, x + 20, y + 6, color);
		}
	}

	@Environment(EnvType.CLIENT)
	public static void tick() {
		if (ticks > 0) {
			--ticks;
		}
	}

	public static void send(class_1657 player, class_1799 stack, int count) {
		send(player, stack, count, null);
	}

	public static void set(class_1799 stack, int count, @Nullable class_2561 str) {
		ItemsRemainingRenderHandler.stack = stack;
		ItemsRemainingRenderHandler.count = count;
		ItemsRemainingRenderHandler.customString = str;
		ticks = stack.method_7960() ? 0 : maxTicks;
	}

	public static void send(class_1657 entity, class_1799 stack, int count, @Nullable class_2561 str) {
		PacketUpdateItemsRemaining.send(entity, stack, count, str);
	}

	public static void send(class_1657 player, class_1799 displayStack, Pattern pattern) {
		int count = 0;
		for (int i = 0; i < player.field_7514.method_5439(); i++) {
			class_1799 stack = player.field_7514.method_5438(i);
			if (!stack.method_7960() && pattern.matcher(stack.method_7922()).find()) {
				count += stack.method_7947();
			}
		}

		send(player, displayStack, count, null);
	}

}
