/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.opengl.GL11;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ICreativeManaProvider;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex.InputHandler;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemCraftingHalo;
import vazkii.botania.common.item.ItemSextant;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemDodgeRing;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_408;
import net.minecraft.class_4587;

public final class HUDHandler {

	private HUDHandler() {}

	public static final class_2960 manaBar = new class_2960(LibResources.GUI_MANA_HUD);

	public static void onDrawScreenPost(class_4587 ms, float partialTicks) {
		class_310 mc = class_310.method_1551();
		class_3695 profiler = mc.method_16011();
		class_1799 main = mc.field_1724.method_6047();
		class_1799 offhand = mc.field_1724.method_6079();

		profiler.method_15396("botania-hud");

		if (class_310.method_1551().field_1761.method_2908()) {
			class_1799 tiara = EquipmentHandler.findOrEmpty(ModItems.flightTiara, mc.field_1724);
			if (!tiara.method_7960()) {
				profiler.method_15396("flugelTiara");
				ItemFlightTiara.renderHUD(ms, mc.field_1724, tiara);
				profiler.method_15407();
			}

			class_1799 dodgeRing = EquipmentHandler.findOrEmpty(ModItems.dodgeRing, mc.field_1724);
			if (!dodgeRing.method_7960()) {
				profiler.method_15396("dodgeRing");
				ItemDodgeRing.renderHUD(ms, mc.field_1724, dodgeRing, partialTicks);
				profiler.method_15407();
			}
		}

		class_239 pos = mc.field_1765;

		if (pos != null) {
			class_2338 bpos = pos.method_17783() == class_239.class_240.field_1332 ? ((class_3965) pos).method_17777() : null;
			class_2680 state = bpos != null ? mc.field_1687.method_8320(bpos) : null;
			class_2248 block = state == null ? null : state.method_26204();
			class_2586 tile = bpos != null ? mc.field_1687.method_8321(bpos) : null;

			if (PlayerHelper.hasAnyHeldItem(mc.field_1724)) {
				if (PlayerHelper.hasHeldItem(mc.field_1724, ModItems.twigWand)) {
					if (block instanceof IWandHUD) {
						profiler.method_15396("wandItem");
						((IWandHUD) block).renderHUD(ms, mc, mc.field_1687, bpos);
						profiler.method_15407();
					}
				}
				if (tile instanceof TilePool && !mc.field_1724.method_6047().method_7960()) {
					renderPoolRecipeHUD(ms, (TilePool) tile, mc.field_1724.method_6047());
				}
			}
			if (!PlayerHelper.hasHeldItem(mc.field_1724, ModItems.lexicon)) {
				if (tile instanceof TileAltar) {
					((TileAltar) tile).renderHUD(ms, mc);
				} else if (tile instanceof TileRuneAltar) {
					((TileRuneAltar) tile).renderHUD(ms, mc);
				} else if (tile instanceof TileCorporeaCrystalCube) {
					renderCrystalCubeHUD(ms, (TileCorporeaCrystalCube) tile);
				}
			}
		}

		TileCorporeaIndex.getInputHandler();
		if (!InputHandler.getNearbyIndexes(mc.field_1724).isEmpty() && mc.field_1755 instanceof class_408) {
			profiler.method_15396("nearIndex");
			renderNearIndexDisplay(ms);
			profiler.method_15407();
		}

		if (!main.method_7960() && main.method_7909() instanceof ItemCraftingHalo) {
			profiler.method_15396("craftingHalo_main");
			ItemCraftingHalo.renderHUD(ms, mc.field_1724, main);
			profiler.method_15407();
		} else if (!offhand.method_7960() && offhand.method_7909() instanceof ItemCraftingHalo) {
			profiler.method_15396("craftingHalo_off");
			ItemCraftingHalo.renderHUD(ms, mc.field_1724, offhand);
			profiler.method_15407();
		}

		if (!main.method_7960() && main.method_7909() instanceof ItemSextant) {
			profiler.method_15396("sextant");
			ItemSextant.renderHUD(ms, mc.field_1724, main);
			profiler.method_15407();
		}

		/*if(equippedStack != null && equippedStack.getItem() == ModItems.flugelEye) {
			profiler.startSection("flugelEye");
			ItemFlugelEye.renderHUD(event.getResolution(), mc.player, equippedStack);
			profiler.endSection();
		}*/

		if (Botania.proxy.isClientPlayerWearingMonocle()) {
			profiler.method_15396("monocle");
			ItemMonocle.renderHUD(ms, mc.field_1724);
			profiler.method_15407();
		}

		profiler.method_15396("manaBar");

		class_1657 player = mc.field_1724;
		if (!player.method_7325()) {
			int totalMana = 0;
			int totalMaxMana = 0;
			boolean anyRequest = false;
			boolean creative = false;

			class_1263 mainInv = player.field_7514;
			class_1263 accInv = BotaniaAPI.instance().getAccessoriesInventory(player);

			int invSize = mainInv.method_5439();
			int size = invSize + accInv.method_5439();

			for (int i = 0; i < size; i++) {
				boolean useAccessories = i >= invSize;
				class_1263 inv = useAccessories ? accInv : mainInv;
				class_1799 stack = inv.method_5438(i - (useAccessories ? invSize : 0));

				if (!stack.method_7960()) {
					class_1792 item = stack.method_7909();
					if (item instanceof IManaUsingItem) {
						anyRequest = anyRequest || ((IManaUsingItem) item).usesMana(stack);
					}
				}
			}

			List<class_1799> items = ManaItemHandler.instance().getManaItems(player);
			for (class_1799 stack : items) {
				class_1792 item = stack.method_7909();
				if (!((IManaItem) item).isNoExport(stack)) {
					totalMana += ((IManaItem) item).getMana(stack);
					totalMaxMana += ((IManaItem) item).getMaxMana(stack);
				}
				if (item instanceof ICreativeManaProvider && ((ICreativeManaProvider) item).isCreative(stack)) {
					creative = true;
				}
			}

			List<class_1799> acc = ManaItemHandler.instance().getManaAccesories(player);
			for (class_1799 stack : acc) {
				class_1792 item = stack.method_7909();
				if (!((IManaItem) item).isNoExport(stack)) {
					totalMana += ((IManaItem) item).getMana(stack);
					totalMaxMana += ((IManaItem) item).getMaxMana(stack);
				}
				if (item instanceof ICreativeManaProvider && ((ICreativeManaProvider) item).isCreative(stack)) {
					creative = true;
				}
			}

			if (anyRequest) {
				renderManaInvBar(ms, creative, totalMana, totalMaxMana);
			}
		}

		profiler.method_15405("itemsRemaining");
		ItemsRemainingRenderHandler.render(ms, partialTicks);
		profiler.method_15407();
		profiler.method_15407();

		RenderSystem.color4f(1F, 1F, 1F, 1F);
	}

	private static void renderManaInvBar(class_4587 ms, boolean hasCreative, int totalMana, int totalMaxMana) {
		class_310 mc = class_310.method_1551();
		int width = 182;
		int x = mc.method_22683().method_4486() / 2 - width / 2;
		int y = mc.method_22683().method_4502() - ConfigHandler.CLIENT.manaBarHeight.getValue();

		if (!hasCreative) {
			if (totalMaxMana == 0) {
				width = 0;
			} else {
				width *= (double) totalMana / (double) totalMaxMana;
			}
		}

		if (width == 0) {
			if (totalMana > 0) {
				width = 1;
			} else {
				return;
			}
		}

		int color = class_3532.method_15369(0.55F, (float) Math.min(1F, Math.sin(class_156.method_658() / 200D) * 0.5 + 1F), 1F);
		int r = (color >> 16 & 0xFF);
		int g = (color >> 8 & 0xFF);
		int b = color & 0xFF;
		RenderSystem.color4f(r / 255F, g / 255F, b / 255F, 1 - (r / 255F));
		mc.method_1531().method_22813(manaBar);

		RenderSystem.enableBlend();
		RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		RenderHelper.drawTexturedModalRect(ms, x, y, 0, 251, width, 5);
		RenderSystem.disableBlend();
		RenderSystem.color4f(1, 1, 1, 1);
	}

	private static void renderPoolRecipeHUD(class_4587 ms, TilePool tile, class_1799 stack) {
		class_310 mc = class_310.method_1551();
		class_3695 profiler = mc.method_16011();

		profiler.method_15396("poolRecipe");
		IManaInfusionRecipe recipe = tile.getMatchingRecipe(stack, tile.method_10997().method_8320(tile.method_11016().method_10074()));
		if (recipe != null) {
			int x = mc.method_22683().method_4486() / 2 - 11;
			int y = mc.method_22683().method_4502() / 2 + 10;

			int u = tile.getCurrentMana() >= recipe.getManaToConsume() ? 0 : 22;
			int v = mc.field_1724.method_5477().getString().equals("haighyorkie") && mc.field_1724.method_5715() ? 23 : 8;

			RenderSystem.enableBlend();
			RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

			mc.method_1531().method_22813(manaBar);
			RenderHelper.drawTexturedModalRect(ms, x, y, u, v, 22, 15);
			RenderSystem.color4f(1F, 1F, 1F, 1F);

			mc.method_1480().method_4023(stack, x - 20, y);
			mc.method_1480().method_4023(recipe.method_8110(), x + 26, y);
			mc.method_1480().method_4025(mc.field_1772, recipe.method_8110(), x + 26, y);

			RenderSystem.disableLighting();
			RenderSystem.disableBlend();
		}
		profiler.method_15407();
	}

	private static void renderCrystalCubeHUD(class_4587 ms, TileCorporeaCrystalCube tile) {
		class_310 mc = class_310.method_1551();
		class_3695 profiler = mc.method_16011();

		profiler.method_15396("crystalCube");
		class_1799 target = tile.getRequestTarget();
		if (!target.method_7960()) {
			String s1 = target.method_7964().getString();
			String s2 = tile.getItemCount() + "x";
			int strlen = Math.max(mc.field_1772.method_1727(s1), mc.field_1772.method_1727(s2));
			int w = mc.method_22683().method_4486();
			int h = mc.method_22683().method_4502();
			int boxH = h / 2 + (tile.locked ? 20 : 10);
			class_332.method_25294(ms, w / 2 + 8, h / 2 - 12, w / 2 + strlen + 32, boxH, 0x44000000);
			class_332.method_25294(ms, w / 2 + 6, h / 2 - 14, w / 2 + strlen + 34, boxH + 2, 0x44000000);

			mc.field_1772.method_1720(ms, s1, w / 2 + 30, h / 2 - 10, 0x6666FF);
			mc.field_1772.method_1720(ms, tile.getItemCount() + "x", w / 2 + 30, h / 2, 0xFFFFFF);
			if (tile.locked) {
				mc.field_1772.method_1720(ms, class_1074.method_4662("botaniamisc.locked"), w / 2 + 30, h / 2 + 10, 0xFFAA00);
			}
			RenderSystem.enableRescaleNormal();
			mc.method_1480().method_4023(target, w / 2 + 10, h / 2 - 10);
		}

		profiler.method_15407();
	}

	private static void renderNearIndexDisplay(class_4587 ms) {
		class_310 mc = class_310.method_1551();
		String txt0 = class_1074.method_4662("botaniamisc.nearIndex0");
		String txt1 = class_124.field_1080 + class_1074.method_4662("botaniamisc.nearIndex1");
		String txt2 = class_124.field_1080 + class_1074.method_4662("botaniamisc.nearIndex2");

		int l = Math.max(mc.field_1772.method_1727(txt0), Math.max(mc.field_1772.method_1727(txt1), mc.field_1772.method_1727(txt2))) + 20;
		int x = mc.method_22683().method_4486() - l - 20;
		int y = mc.method_22683().method_4502() - 60;

		class_332.method_25294(ms, x - 6, y - 6, x + l + 6, y + 37, 0x44000000);
		class_332.method_25294(ms, x - 4, y - 4, x + l + 4, y + 35, 0x44000000);
		RenderSystem.enableRescaleNormal();
		mc.method_1480().method_4023(new class_1799(ModBlocks.corporeaIndex), x, y + 10);

		mc.field_1772.method_1720(ms, txt0, x + 20, y, 0xFFFFFF);
		mc.field_1772.method_1720(ms, txt1, x + 20, y + 14, 0xFFFFFF);
		mc.field_1772.method_1720(ms, txt2, x + 20, y + 24, 0xFFFFFF);
	}

	public static void drawSimpleManaHUD(class_4587 ms, int color, int mana, int maxMana, String name) {
		RenderSystem.enableBlend();
		RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		class_310 mc = class_310.method_1551();
		int x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(name) / 2;
		int y = mc.method_22683().method_4502() / 2 + 10;

		mc.field_1772.method_1720(ms, name, x, y, color);

		x = mc.method_22683().method_4486() / 2 - 51;
		y += 10;

		renderManaBar(ms, x, y, color, 1F, mana, maxMana);

		RenderSystem.disableBlend();
	}

	public static void drawComplexManaHUD(int color, class_4587 ms, int mana, int maxMana, String name, class_1799 bindDisplay, boolean properlyBound) {
		drawSimpleManaHUD(ms, color, mana, maxMana, name);

		class_310 mc = class_310.method_1551();

		int x = mc.method_22683().method_4486() / 2 + 55;
		int y = mc.method_22683().method_4502() / 2 + 12;

		RenderSystem.enableRescaleNormal();
		mc.method_1480().method_4023(bindDisplay, x, y);

		RenderSystem.disableDepthTest();
		if (properlyBound) {
			mc.field_1772.method_1720(ms, "\u2714", x + 10, y + 9, 0x004C00);
			mc.field_1772.method_1720(ms, "\u2714", x + 10, y + 8, 0x0BD20D);
		} else {
			mc.field_1772.method_1720(ms, "\u2718", x + 10, y + 9, 0x4C0000);
			mc.field_1772.method_1720(ms, "\u2718", x + 10, y + 8, 0xD2080D);
		}
		RenderSystem.enableDepthTest();
	}

	public static void renderManaBar(class_4587 ms, int x, int y, int color, float alpha, int mana, int maxMana) {
		class_310 mc = class_310.method_1551();

		RenderSystem.color4f(1F, 1F, 1F, alpha);
		mc.method_1531().method_22813(manaBar);
		RenderHelper.drawTexturedModalRect(ms, x, y, 0, 0, 102, 5);

		int manaPercentage = Math.max(0, (int) ((double) mana / (double) maxMana * 100));

		if (manaPercentage == 0 && mana > 0) {
			manaPercentage = 1;
		}

		RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, 100, 3);

		float red = (color >> 16 & 0xFF) / 255F;
		float green = (color >> 8 & 0xFF) / 255F;
		float blue = (color & 0xFF) / 255F;
		RenderSystem.color4f(red, green, blue, alpha);
		RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, Math.min(100, manaPercentage), 3);
		RenderSystem.color4f(1, 1, 1, 1);
	}
}
