/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLCapabilities;

import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.lib.LibMisc;

import java.util.List;

public final class DebugHandler {

	private DebugHandler() {}

	private static final String PREFIX = class_124.field_1060 + "[Botania] " + class_124.field_1070;

	public static void onDrawDebugText(List<String> left) {
		class_1937 world = class_310.method_1551().field_1687;
		if (ConfigHandler.CLIENT.debugInfo.getValue()) {
			left.add("");
			String version = FabricLoader.getInstance().getModContainer(LibMisc.MOD_ID)
					.map(m -> m.getMetadata().getVersion().getFriendlyString())
					.orElse("N/A");

			left.add(PREFIX + "(CLIENT) netColl: " + ManaNetworkHandler.instance.getAllCollectorsInWorld(world).size() + ", netPool: " + ManaNetworkHandler.instance.getAllPoolsInWorld(world).size() + ", rv: " + version);

			if (class_310.method_1551().method_1496()) {
				class_5321<class_1937> dim = class_310.method_1551().field_1687.method_27983();
				class_2960 dimName = dim.method_29177();
				if (class_310.method_1551().method_1576() != null) {
					class_1937 serverWorld = class_310.method_1551().method_1576().method_3847(dim);
					left.add(PREFIX + String.format("(INTEGRATED SERVER %s) netColl : %d, netPool: %d", dimName, ManaNetworkHandler.instance.getAllCollectorsInWorld(serverWorld).size(), ManaNetworkHandler.instance.getAllPoolsInWorld(serverWorld).size()));
				}
			}

			if (class_437.method_25441() && class_437.method_25442()) {
				left.add(PREFIX + "Config Context");
				left.add("  shaders.enabled: " + ConfigHandler.CLIENT.useShaders.getValue());

				GLCapabilities caps = GL.getCapabilities();
				left.add(PREFIX + "OpenGL Context");
				left.add("  GL_VERSION: " + GL11.glGetString(GL11.GL_VERSION));
				left.add("  GL_RENDERER: " + GL11.glGetString(GL11.GL_RENDERER));
				left.add("  GL_SHADING_LANGUAGE_VERSION: " + GL11.glGetString(GL20.GL_SHADING_LANGUAGE_VERSION));
				left.add("  GL_ARB_multitexture: " + caps.GL_ARB_multitexture);
				left.add("  GL_ARB_texture_non_power_of_two: " + caps.GL_ARB_texture_non_power_of_two);
				left.add("  OpenGL13: " + caps.OpenGL13);
			} else if (class_310.field_1703) {
				left.add(PREFIX + "SHIFT+CMD for context");
			} else {
				left.add(PREFIX + "SHIFT+CTRL for context");
			}
		}
	}

}
