/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.network.PacketIndexKeybindRequest;
import vazkii.botania.mixin.AccessorHandledScreen;
import vazkii.botania.mixin.AccessorRecipeBookGui;
import vazkii.botania.mixin.AccessorRecipeBookPage;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_507;
import net.minecraft.class_513;
import net.minecraft.class_514;

public class CorporeaInputHandler {

	/** Replaced in JEIBotaniaPlugin when JEI's loaded to provide stacks from the JEI item panel. */
	public static Supplier<class_1799> jeiPanelSupplier = () -> class_1799.field_8037;

	/** Filter for usable guis to handle requests. Added to in JEIBotaniaPlugin */
	public static Predicate<class_437> supportedGuiFilter = gui -> gui instanceof class_465;

	public static boolean buttonPressed(int keyCode, int scanCode) {
		class_310 mc = class_310.method_1551();

		if (mc.field_1687 == null || !supportedGuiFilter.test(mc.field_1755)
				|| !ClientProxy.CORPOREA_REQUEST.method_1417(keyCode, scanCode)
				|| TileCorporeaIndex.InputHandler.getNearbyIndexes(mc.field_1724).isEmpty()) {
			return false;
		}

		class_1799 stack = getStackUnderMouse();
		if (stack != null && !stack.method_7960()) {
			int count = 1;
			int max = stack.method_7914();

			if (class_437.method_25442()) {
				count = max;
				if (class_437.method_25441()) {
					count /= 4;
				}
			} else if (class_437.method_25441()) {
				count = max / 2;
			}

			if (count > 0) {
				class_1799 requested = stack.method_7972();
				requested.method_7939(count);
				PacketIndexKeybindRequest.send(requested);
				return true;
			}
		}
		return false;
	}

	private static class_1799 getStackUnderMouse() {
		class_437 screen = class_310.method_1551().field_1755;
		if (screen instanceof class_465) {
			class_1735 slotUnderMouse = ((AccessorHandledScreen) screen).getFocusedSlot();
			if (slotUnderMouse != null) {
				class_1799 stack = slotUnderMouse.method_7677().method_7972();
				stack.method_7980(null); // Wipe NBT of inventory items before request, as player items will often have data
				return stack; // that's better to ignore. This is still an improvement over matching names only.
			}
		}

		if (screen instanceof class_490 && ((class_490) screen).method_2659().method_2605()) {
			class_507 recipeBook = ((class_490) screen).method_2659();
			class_513 page = ((AccessorRecipeBookGui) recipeBook).getRecipesArea();
			class_514 widget = ((AccessorRecipeBookPage) page).getHoveredResultButton();
			if (widget != null) {
				return widget.method_2643().method_8110();
			}
		}

		return jeiPanelSupplier.get();
	}
}
