/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableMap;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ModTags;

import javax.annotation.Nonnull;
import net.minecraft.class_140;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_809;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.*;

public final class ContributorFancinessHandler extends class_3887<class_742, class_591<class_742>> {

	public static final String TAG_HEADFLOWER = "botania:headflower";
	private static volatile Map<String, class_1799> flowerMap = Collections.emptyMap();
	private static boolean startedLoading = false;

	private static final ImmutableMap<String, String> LEGACY_FLOWER_NAMES = ImmutableMap.<String, String>builder()
			.put("daybloom", LibBlockNames.MOTIF_DAYBLOOM)
			.put("nightshade", LibBlockNames.MOTIF_NIGHTSHADE)
			.put("puredaisy", LibBlockNames.SUBTILE_PUREDAISY.method_12832())
			.put("fallenkanade", LibBlockNames.SUBTILE_FALLEN_KANADE.method_12832())
			.put("heiseidream", LibBlockNames.SUBTILE_HEISEI_DREAM.method_12832())
			.put("arcanerose", LibBlockNames.SUBTILE_ARCANE_ROSE.method_12832())
			.put("jadedamaranthus", LibBlockNames.SUBTILE_JADED_AMARANTHUS.method_12832())
			.put("orechidignem", LibBlockNames.SUBTILE_ORECHID_IGNEM.method_12832())
			.build();

	public ContributorFancinessHandler(class_3883<class_742, class_591<class_742>> renderer) {
		super(renderer);
	}

	@Override
	public void render(class_4587 ms, class_4597 buffers, int light, @Nonnull class_742 player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		firstStart();

		if (player.method_5767()) {
			return;
		}

		String name = player.method_7334().getName();

		if (name.equals("haighyorkie")) {
			renderGoldfish(ms, buffers);
		}

		if (player.method_7348(class_1664.field_7559)) {
			class_1799 flower = getFlower(name.toLowerCase(Locale.ROOT));
			if (!flower.method_7960()) {
				renderFlower(ms, buffers, player, flower);
			}
		}

	}

	public static void firstStart() {
		if (!startedLoading) {
			new ThreadContributorListLoader();
			startedLoading = true;
		}
	}

	public static class_1799 getFlower(String name) {
		return flowerMap.getOrDefault(name, class_1799.field_8037);
	}

	public static void load(Properties props) {
		Map<String, class_1799> m = new HashMap<>();
		for (String key : props.stringPropertyNames()) {
			String value = props.getProperty(key);

			class_1799 stack;
			try {
				int i = Integer.parseInt(value);
				if (i < 0 || i >= 16) {
					throw new NumberFormatException();
				}
				stack = new class_1799(ModBlocks.getFlower(class_1767.method_7791(i)));
			} catch (NumberFormatException e) {
				String rawName = value.toLowerCase(Locale.ROOT);
				String flowerName = LEGACY_FLOWER_NAMES.getOrDefault(rawName, rawName);

				class_1792 item = ModTags.Items.CONTRIBUTOR_HEADFLOWERS.method_15138().stream()
						.filter(flower -> class_2378.field_11142.method_10221(flower).method_12832().equals(flowerName))
						.findFirst().orElse(class_1802.field_8880);
				stack = new class_1799(item);
			}
			configureStack(stack);
			m.put(key, stack);
		}
		flowerMap = m;
	}

	private static void configureStack(class_1799 stack) {
		Map<class_1887, Integer> ench = new HashMap<>();
		ench.put(class_1893.field_9119, 1);
		class_2378.field_11160.method_17966(new class_2960("charm", "tinted")).ifPresent(e -> ench.put(e, 1));
		class_1890.method_8214(ench, stack);

		stack.method_7969().method_10556(TAG_HEADFLOWER, true);
		stack.method_7969().method_10582("charm_glint", class_1767.field_7947.method_7792());
	}

	private void renderGoldfish(class_4587 ms, class_4597 buffers) {
		ms.method_22903();
		method_17165().field_3398.method_22703(ms);
		ms.method_22904(-0.15F, -0.60F, 0F);
		ms.method_22905(0.4F, -0.4F, -0.4F);
		class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffers.getBuffer(class_4722.method_24076()), null, MiscellaneousIcons.INSTANCE.goldfishModel, 1, 1, 1, 0xF000F0, class_4608.field_21444);
		ms.method_22909();
	}

	private void renderFlower(class_4587 ms, class_4597 buffers, class_1657 player, class_1799 flower) {
		ms.method_22903();
		method_17165().field_3398.method_22703(ms);
		ms.method_22904(0, -0.75, 0);
		ms.method_22905(0.5F, -0.5F, -0.5F);
		class_310.method_1551().method_1480().method_23177(player, flower, class_809.class_811.field_4315, false, ms, buffers, player.field_6002, 0xF000F0, class_4608.field_21444);
		ms.method_22909();
	}

	private static class ThreadContributorListLoader extends Thread {

		public ThreadContributorListLoader() {
			setName("Botania Contributor Fanciness Thread");
			setDaemon(true);
			setUncaughtExceptionHandler(new class_140(Botania.LOGGER));
			start();
		}

		@Override
		public void run() {
			try {
				URL url = new URL("https://raw.githubusercontent.com/Vazkii/Botania/master/contributors.properties");
				Properties props = new Properties();
				try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8)) {
					props.load(reader);
					load(props);
				}
			} catch (IOException e) {
				Botania.LOGGER.info("Could not load contributors list. Either you're offline or github is down. Nothing to worry about, carry on~");
			}
		}

	}

}
