/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1163;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1926;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3532;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.TilePlatform;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.common.item.*;
import vazkii.botania.common.item.equipment.bauble.ItemBloodPendant;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.material.ItemPetal;

public final class ColorHandler {

	public static void init() {
		ColorProviderRegistry<class_2248, class_322> blocks = ColorProviderRegistry.BLOCK;

		// [VanillaCopy] BlockColors for vine
		class_322 vineColor = (state, world, pos, tint) -> world != null && pos != null ? class_1163.method_4966(world, pos) : class_1926.method_8341();
		blocks.register(vineColor, ModBlocks.solidVines);

		// Pool
		blocks.register(
				(state, world, pos, tintIndex) -> {
					if (tintIndex != 0) {
						return -1;
					}

					int color = ColorHelper.getColorValue(class_1767.field_7952);
					if (world != null && pos != null) {
						class_2586 te = world.method_8321(pos);
						if (te instanceof TilePool) {
							color = ColorHelper.getColorValue(((TilePool) te).color);
						}
					}
					if (((BlockPool) state.method_26204()).variant == BlockPool.Variant.FABULOUS) {
						float time = (ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.005F;
						int fabulousColor = class_3532.method_15369(time - (int) time, 0.6F, 1F);
						return vazkii.botania.common.core.helper.MathHelper.multiplyColor(fabulousColor, color);
					}
					return color;
				},
				ModBlocks.manaPool, ModBlocks.creativePool, ModBlocks.dilutedPool, ModBlocks.fabulousPool
		);

		// Spreader
		blocks.register(
				(state, world, pos, tintIndex) -> {
					float time = ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
					return class_3532.method_15369(time * 5 % 360 / 360F, 0.4F, 0.9F);
				},
				ModBlocks.gaiaSpreader
		);

		// Petal Block
		blocks.register((state, world, pos, tintIndex) -> tintIndex == 0 ? ColorHelper.getColorValue(((BlockPetalBlock) state.method_26204()).color) : -1,
				ModBlocks.petalBlockWhite, ModBlocks.petalBlockOrange, ModBlocks.petalBlockMagenta, ModBlocks.petalBlockLightBlue,
				ModBlocks.petalBlockYellow, ModBlocks.petalBlockLime, ModBlocks.petalBlockPink, ModBlocks.petalBlockGray,
				ModBlocks.petalBlockSilver, ModBlocks.petalBlockCyan, ModBlocks.petalBlockPurple, ModBlocks.petalBlockBlue,
				ModBlocks.petalBlockBrown, ModBlocks.petalBlockGreen, ModBlocks.petalBlockRed, ModBlocks.petalBlockBlack
		);

		// Platforms
		blocks.register(
				(state, world, pos, tintIndex) -> {
					if (world != null && pos != null) {
						class_2586 tile = world.method_8321(pos);
						if (tile instanceof TilePlatform) {
							TilePlatform camo = (TilePlatform) tile;
							class_2680 camoState = camo.getCamoState();
							if (camoState != null) {
								return camoState.method_26204() instanceof BlockPlatform
										? 0xFFFFFF
										: class_310.method_1551().method_1505().method_1697(camoState, world, pos, tintIndex);
							}
						}
					}
					return 0xFFFFFF;
				}, ModBlocks.abstrusePlatform, ModBlocks.spectralPlatform, ModBlocks.infrangiblePlatform);

		ColorProviderRegistry<class_1935, class_326> items = ColorProviderRegistry.ITEM;

		items.register((s, t) -> t == 0 ? class_3532.method_15369(ClientTickHandler.ticksInGame * 2 % 360 / 360F, 0.25F, 1F) : -1,
				ModItems.lifeEssence, ModItems.gaiaIngot);

		items.register((s, t) -> t == 1 ? ColorHelper.getColorValue(class_1767.method_7791(ItemTwigWand.getColor1(s)))
				: t == 2 ? ColorHelper.getColorValue(class_1767.method_7791(ItemTwigWand.getColor2(s)))
				: -1,
				ModItems.twigWand);

		class_326 petalHandler = (s, t) -> t == 0 ? ColorHelper.getColorValue(((ItemPetal) s.method_7909()).color) : -1;
		for (class_1767 color : class_1767.values()) {
			items.register(petalHandler, ModItems.getPetal(color));
		}

		items.register((s, t) -> t == 0 ? class_310.method_1551().method_1505().method_1697(((class_1747) s.method_7909()).method_7711().method_9564(), null, null, t) : -1,
				ModBlocks.petalBlockWhite, ModBlocks.petalBlockOrange, ModBlocks.petalBlockMagenta, ModBlocks.petalBlockLightBlue,
				ModBlocks.petalBlockYellow, ModBlocks.petalBlockLime, ModBlocks.petalBlockPink, ModBlocks.petalBlockGray,
				ModBlocks.petalBlockSilver, ModBlocks.petalBlockCyan, ModBlocks.petalBlockPurple, ModBlocks.petalBlockBlue,
				ModBlocks.petalBlockBrown, ModBlocks.petalBlockGreen, ModBlocks.petalBlockRed, ModBlocks.petalBlockBlack,
				ModBlocks.manaPool, ModBlocks.creativePool, ModBlocks.dilutedPool, ModBlocks.fabulousPool, ModBlocks.gaiaSpreader);

		items.register((s, t) -> t == 1 ? class_3532.method_15369(0.528F, (float) ((ItemManaMirror) ModItems.manaMirror).getMana(s) / (float) TilePool.MAX_MANA, 1F) : -1, ModItems.manaMirror);

		items.register((s, t) -> t == 1 ? class_3532.method_15369(0.528F, (float) ((ItemManaTablet) ModItems.manaTablet).getMana(s) / (float) ItemManaTablet.MAX_MANA, 1F) : -1, ModItems.manaTablet);

		items.register((s, t) -> t == 0 ? class_3532.method_15369(0.55F, ((float) s.method_7936() - (float) s.method_7919()) / (float) s.method_7936() * 0.5F, 1F) : -1, ModItems.spellCloth);

		items.register((s, t) -> {
			if (t != 1) {
				return -1;
			}

			Brew brew = ((IBrewItem) s.method_7909()).getBrew(s);
			if (brew == ModBrews.fallbackBrew) {
				return s.method_7909() instanceof ItemBloodPendant ? 0xC6000E : 0x989898;
			}

			int color = brew.getColor(s);
			double speed = s.method_7909() == ModItems.brewFlask || s.method_7909() == ModItems.brewVial ? 0.1 : 0.2;
			int add = (int) (Math.sin(ClientTickHandler.ticksInGame * speed) * 24);

			int r = Math.max(0, Math.min(255, (color >> 16 & 0xFF) + add));
			int g = Math.max(0, Math.min(255, (color >> 8 & 0xFF) + add));
			int b = Math.max(0, Math.min(255, (color & 0xFF) + add));

			return r << 16 | g << 8 | b;
		}, ModItems.bloodPendant, ModItems.incenseStick, ModItems.brewFlask, ModItems.brewVial);

		items.register((s, t) -> {
			class_1799 lens = ItemManaGun.getLens(s);
			if (!lens.method_7960() && t == 0) {
				return ColorProviderRegistry.ITEM.get(lens.method_7909()).getColor(lens, t);
			}

			if (t == 2) {
				BurstProperties props = ((ItemManaGun) s.method_7909()).getBurstProps(class_310.method_1551().field_1724, s, false, class_1268.field_5808);

				float mul = (float) (Math.sin((double) ClientTickHandler.ticksInGame / 5) * 0.15F);
				int c = (int) (255 * mul);

				int r = (props.color >> 16 & 0xFF) + c;
				int g = (props.color >> 8 & 0xFF) + c;
				int b = (props.color & 0xFF) + c;

				int cr = class_3532.method_15340(r, 0, 255);
				int cg = class_3532.method_15340(g, 0, 255);
				int cb = class_3532.method_15340(b, 0, 255);

				return cr << 16 | cg << 8 | cb;
			} else {
				return -1;
			}
		}, ModItems.manaGun);

		items.register((s, t) -> t == 1 ? class_3532.method_15369(0.75F, 1F, 1.5F - (float) Math.min(1F, Math.sin(class_156.method_658() / 100D) * 0.5 + 1.2F)) : -1, ModItems.enderDagger);

		items.register((s, t) -> t == 1 && ItemTerraPick.isEnabled(s) ? class_3532.method_15369(0.375F, (float) Math.min(1F, Math.sin(class_156.method_658() / 200D) * 0.5 + 1F), 1F) : -1, ModItems.terraPick);

		class_326 lensHandler = (s, t) -> t == 0 ? ((ItemLens) s.method_7909()).getLensColor(s) : -1;
		items.register(lensHandler, ModItems.lensNormal, ModItems.lensSpeed, ModItems.lensPower, ModItems.lensTime, ModItems.lensEfficiency, ModItems.lensBounce,
				ModItems.lensGravity, ModItems.lensMine, ModItems.lensDamage, ModItems.lensPhantom, ModItems.lensMagnet,
				ModItems.lensExplosive, ModItems.lensWeight, ModItems.lensPaint, ModItems.lensFire, ModItems.lensPiston,
				ModItems.lensLight, ModItems.lensWarp, ModItems.lensRedirect, ModItems.lensFirework, ModItems.lensFlare,
				ModItems.lensMessenger, ModItems.lensTripwire, ModItems.lensStorm);
	}

	private ColorHandler() {}

}
