/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableList;
import net.minecraft.class_1657;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.client.render.tile.RenderTileRedString;
import vazkii.botania.common.block.subtile.functional.SubTileVinculotus;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;

public final class ClientTickHandler {

	private ClientTickHandler() {}

	public static int ticksWithLexicaOpen = 0;
	public static int pageFlipTicks = 0;
	public static int ticksInGame = 0;
	public static float partialTicks = 0;
	public static float delta = 0;
	public static float total = 0;

	public static void calcDelta() {
		float oldTotal = total;
		total = ticksInGame + partialTicks;
		delta = total - oldTotal;
	}

	public static void renderTick(float renderTickTime) {
		partialTicks = renderTickTime;
	}

	public static void clientTickEnd(class_310 mc) {
		RenderTileRedString.tick();
		ItemsRemainingRenderHandler.tick();

		if (class_310.method_1551().field_1687 == null) {
			ManaNetworkHandler.instance.clear();
			SubTileVinculotus.existingFlowers.clear();
		}

		if (!mc.method_1493()) {
			ticksInGame++;
			partialTicks = 0;

			class_1657 player = mc.field_1724;
			if (player != null) {
				if (PlayerHelper.hasHeldItemClass(player, ModItems.twigWand)) {
					for (class_2586 tile : ImmutableList.copyOf(ManaNetworkHandler.instance.getAllCollectorsInWorld(class_310.method_1551().field_1687))) {
						if (tile instanceof IManaCollector) {
							((IManaCollector) tile).onClientDisplayTick();
						}
					}
				}
			}
		}

		int ticksToOpen = 10;
		if (ItemLexicon.isOpen()) {
			if (ticksWithLexicaOpen < 0) {
				ticksWithLexicaOpen = 0;
			}
			if (ticksWithLexicaOpen < ticksToOpen) {
				ticksWithLexicaOpen++;
			}
			if (pageFlipTicks > 0) {
				pageFlipTicks--;
			}
		} else {
			pageFlipTicks = 0;
			if (ticksWithLexicaOpen > 0) {
				if (ticksWithLexicaOpen > ticksToOpen) {
					ticksWithLexicaOpen = ticksToOpen;
				}
				ticksWithLexicaOpen--;
			}
		}

		calcDelta();
	}

	public static void notifyPageChange() {
		if (pageFlipTicks == 0) {
			pageFlipTicks = 5;
		}
	}

}
