/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.IWireframeAABBProvider;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.core.handler.ConfigHandler;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1159;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public final class BoundTileRenderer {
	private static final class_4597.class_4598 LINE_BUFFERS = class_4597.method_22992(class_156.method_656(() -> {
		Map<class_1921, class_287> ret = new IdentityHashMap<>();
		ret.put(RenderHelper.LINE_1_NO_DEPTH, new class_287(RenderHelper.LINE_1_NO_DEPTH.method_22722()));
		ret.put(RenderHelper.LINE_4_NO_DEPTH, new class_287(RenderHelper.LINE_4_NO_DEPTH.method_22722()));
		ret.put(RenderHelper.LINE_5_NO_DEPTH, new class_287(RenderHelper.LINE_5_NO_DEPTH.method_22722()));
		ret.put(RenderHelper.LINE_8_NO_DEPTH, new class_287(RenderHelper.LINE_8_NO_DEPTH.method_22722()));
		return ret;
	}), class_289.method_1348().method_1349());

	private BoundTileRenderer() {}

	public static void onWorldRenderLast(class_4587 ms) {
		if (!ConfigHandler.CLIENT.boundBlockWireframe.getValue()) {
			return;
		}

		ms.method_22903();

		class_1657 player = class_310.method_1551().field_1724;
		int color = 0xFF000000 | class_3532.method_15369(ClientTickHandler.ticksInGame % 200 / 200F, 0.6F, 1F);

		if (!player.method_6047().method_7960() && player.method_6047().method_7909() instanceof ICoordBoundItem) {
			class_2338 coords = ((ICoordBoundItem) player.method_6047().method_7909()).getBinding(player.field_6002, player.method_6047());
			if (coords != null) {
				renderBlockOutlineAt(ms, LINE_BUFFERS, coords, color);
			}
		}

		if (!player.method_6079().method_7960() && player.method_6079().method_7909() instanceof ICoordBoundItem) {
			class_2338 coords = ((ICoordBoundItem) player.method_6079().method_7909()).getBinding(player.field_6002, player.method_6079());
			if (coords != null) {
				renderBlockOutlineAt(ms, LINE_BUFFERS, coords, color);
			}
		}

		renderWireframeProviders(player.field_7514, player, ms, color);
		renderWireframeProviders(BotaniaAPI.instance().getAccessoriesInventory(player), player, ms, color);

		ms.method_22909();
		RenderSystem.disableDepthTest();
		LINE_BUFFERS.method_22993();
	}

	private static void renderWireframeProviders(class_1263 inv, class_1657 player, class_4587 ms, int color) {
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stackInSlot = inv.method_5438(i);

			if (!stackInSlot.method_7960() && stackInSlot.method_7909() instanceof IWireframeCoordinateListProvider) {
				IWireframeCoordinateListProvider provider = (IWireframeCoordinateListProvider) stackInSlot.method_7909();
				List<class_2338> coordsList = provider.getWireframesToDraw(player, stackInSlot);
				for (class_2338 coords : coordsList) {
					renderBlockOutlineAt(ms, LINE_BUFFERS, coords, color);
				}

				class_2338 coords = provider.getSourceWireframe(player, stackInSlot);
				if (coords != null && coords.method_10264() > -1) {
					renderBlockOutlineAt(ms, LINE_BUFFERS, coords, color, true);
				}
			}
		}
	}

	private static void renderBlockOutlineAt(class_4587 ms, class_4597 buffers, class_2338 pos, int color) {
		renderBlockOutlineAt(ms, buffers, pos, color, false);
	}

	private static void renderBlockOutlineAt(class_4587 ms, class_4597 buffers, class_2338 pos, int color, boolean thick) {
		double renderPosX = class_310.method_1551().method_1561().field_4686.method_19326().method_10216();
		double renderPosY = class_310.method_1551().method_1561().field_4686.method_19326().method_10214();
		double renderPosZ = class_310.method_1551().method_1561().field_4686.method_19326().method_10215();

		ms.method_22903();
		ms.method_22904(pos.method_10263() - renderPosX, pos.method_10264() - renderPosY, pos.method_10260() - renderPosZ + 1);

		class_1937 world = class_310.method_1551().field_1687;
		class_2680 state = world.method_8320(pos);
		class_2248 block = state.method_26204();
		List<class_238> list;

		if (block instanceof IWireframeAABBProvider) {
			list = ((IWireframeAABBProvider) block).getWireframeAABB(world, pos);
		} else {
			class_265 shape = state.method_26218(world, pos);
			list = shape.method_1090().stream().map(b -> b.method_996(pos)).collect(Collectors.toList());
		}

		if (!list.isEmpty()) {
			ms.method_22905(1F, 1F, 1F);

			class_4588 buffer = buffers.getBuffer(thick ? RenderHelper.LINE_5_NO_DEPTH : RenderHelper.LINE_1_NO_DEPTH);
			for (class_238 axis : list) {
				axis = axis.method_989(-pos.method_10263(), -pos.method_10264(), -(pos.method_10260() + 1));
				renderBlockOutline(ms.method_23760().method_23761(), buffer, axis, color);
			}

			buffer = buffers.getBuffer(thick ? RenderHelper.LINE_8_NO_DEPTH : RenderHelper.LINE_4_NO_DEPTH);
			int alpha = 64;
			color = (color & ~0xff000000) | (alpha << 24);
			for (class_238 axis : list) {
				axis = axis.method_989(-pos.method_10263(), -pos.method_10264(), -(pos.method_10260() + 1));
				renderBlockOutline(ms.method_23760().method_23761(), buffer, axis, color);
			}
		}

		ms.method_22909();
	}

	private static void renderBlockOutline(class_1159 mat, class_4588 buffer, class_238 aabb, int color) {
		float ix = (float) aabb.field_1323;
		float iy = (float) aabb.field_1322;
		float iz = (float) aabb.field_1321;
		float ax = (float) aabb.field_1320;
		float ay = (float) aabb.field_1325;
		float az = (float) aabb.field_1324;
		int a = (color >> 24) & 0xFF;
		int r = (color >> 16) & 0xFF;
		int g = (color >> 8) & 0xFF;
		int b = color & 0xFF;

		buffer.method_22918(mat, ix, iy, iz).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ix, ay, iz).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ix, ay, iz).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ax, ay, iz).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ax, ay, iz).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ax, iy, iz).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ax, iy, iz).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ix, iy, iz).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ix, iy, az).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ix, ay, az).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ix, iy, az).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ax, iy, az).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ax, iy, az).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ax, ay, az).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ix, ay, az).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ax, ay, az).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ix, iy, iz).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ix, iy, az).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ix, ay, iz).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ix, ay, az).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ax, iy, iz).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ax, iy, az).method_1336(r, g, b, a).method_1344();

		buffer.method_22918(mat, ax, ay, iz).method_1336(r, g, b, a).method_1344();
		buffer.method_22918(mat, ax, ay, az).method_1336(r, g, b, a).method_1344();
	}
}
