/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.wand;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

/**
 * A TileEntity that implements this can be bound to another block
 * via the Wand of the Forest. Also see IWireframeAABBProvider to change
 * the displayed bounding box.
 */
public interface IWandBindable extends ITileBound {

	/**
	 * Return true if the Wand can select this tile.
	 */
	public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side);

	/**
	 * Call to bind the TileEntity to where the player clicked. Return true to deselect
	 * the TileEntity for another bind or false case the TileEntity should stay selected.
	 */
	public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side);

}
