/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.subtile;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3000;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.capability.FloatingFlowerImpl;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.item.IFloatingFlowerProvider;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.string.TileRedStringRelay;
import vazkii.botania.common.lib.ModTags;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Common superclass of all magical flower TE's
 */
public class TileEntitySpecialFlower extends class_2586 implements class_3000, IWandBindable, IFloatingFlowerProvider, RenderAttachmentBlockEntity, BlockEntityClientSerializable {
	public static final class_2960 DING_SOUND_EVENT = new class_2960(BotaniaAPI.MODID, "ding");
	public static final int SLOWDOWN_FACTOR_PODZOL = 5;
	public static final int SLOWDOWN_FACTOR_MYCEL = 10;

	private final IFloatingFlower floatingData = new FloatingFlowerImpl() {
		@Override
		public class_1799 getDisplayStack() {
			class_2960 id = class_2378.field_11137.method_10221(method_11017());
			return class_2378.field_11142.method_17966(id).map(class_1799::new).orElse(super.getDisplayStack());
		}
	};

	public int ticksExisted = 0;

	/** true if this flower is working on Enchanted Soil **/
	public boolean overgrowth = false;
	/** true if this flower is working on Enchanted Soil and this is the second tick **/
	public boolean overgrowthBoost = false;
	private class_2338 positionOverride;

	public static final String TAG_TICKS_EXISTED = "ticksExisted";
	private static final String TAG_FLOATING_DATA = "floating";

	public TileEntitySpecialFlower(class_2591<?> type) {
		super(type);
	}

	@Override
	public final void method_16896() {
		class_2586 tileBelow = field_11863.method_8321(field_11867.method_10074());
		if (tileBelow instanceof TileRedStringRelay) {
			class_2338 coords = ((TileRedStringRelay) tileBelow).getBinding();
			if (coords != null) {
				positionOverride = coords;
				tickFlower();

				return;
			} else {
				positionOverride = null;
			}
		} else {
			positionOverride = null;
		}

		boolean special = isOnSpecialSoil();
		if (special) {
			this.overgrowth = true;
			if (isOvergrowthAffected()) {
				tickFlower();
				overgrowthBoost = true;
			}
		}
		tickFlower();
		overgrowth = false;
		overgrowthBoost = false;
	}

	@Nullable
	@Override
	public IFloatingFlower getFloatingData() {
		if (method_11002() && method_11010().method_26164(ModTags.Blocks.SPECIAL_FLOATING_FLOWERS)) {
			return floatingData;
		}
		return null;
	}

	public boolean isFloating() {
		return getFloatingData() != null;
	}

	private boolean isOnSpecialSoil() {
		if (isFloating()) {
			return false;
		} else {
			return field_11863.method_8320(field_11867.method_10074()).method_26204() == ModBlocks.enchantedSoil;
		}
	}

	/**
	 * @return Where this flower's effects are centered at. This can differ from the true TE location due to
	 *         red string spoofers.
	 */
	public final class_2338 getEffectivePos() {
		return positionOverride != null ? positionOverride : method_11016();
	}

	protected void tickFlower() {
		ticksExisted++;
	}

	@Override
	public final void method_11014(class_2680 state, class_2487 cmp) {
		super.method_11014(state, cmp);
		if (cmp.method_10545(TAG_TICKS_EXISTED)) {
			ticksExisted = cmp.method_10550(TAG_TICKS_EXISTED);
		}
		readFromPacketNBT(cmp);
	}

	@Nonnull
	@Override
	public final class_2487 method_11007(class_2487 cmp) {
		cmp = super.method_11007(cmp);
		cmp.method_10569(TAG_TICKS_EXISTED, ticksExisted);
		writeToPacketNBT(cmp);
		return cmp;
	}

	@Override
	public class_2487 toClientTag(class_2487 compoundTag) {
		writeToPacketNBT(compoundTag);
		return compoundTag;
	}

	@Override
	public void fromClientTag(class_2487 tag) {
		IFloatingFlower.IslandType oldType = floatingData.getIslandType();
		readFromPacketNBT(tag);
		if (oldType != floatingData.getIslandType() && isFloating()) {
			field_11863.method_8413(method_11016(), method_11010(), method_11010(), 0);
		}
	}

	@Nonnull
	@Override
	public class_2487 method_16887() {
		return method_11007(new class_2487());
	}

	/**
	 * Writes some extra data to a network packet. This data is read
	 * by readFromPacketNBT on the client that receives the packet.
	 * Note: This method is also used to write to the world NBT.
	 */
	public void writeToPacketNBT(class_2487 cmp) {
		if (isFloating()) {
			cmp.method_10566(TAG_FLOATING_DATA, floatingData.writeNBT());
		}
	}

	/**
	 * Reads data from a network packet. This data is written by
	 * writeToPacketNBT in the server. Note: This method is also used
	 * to read from the world NBT.
	 */
	public void readFromPacketNBT(class_2487 cmp) {
		if (cmp.method_10545(TAG_FLOATING_DATA)) {
			floatingData.readNBT(cmp.method_10562(TAG_FLOATING_DATA));
		}
	}

	@Override
	public void sync() {
		VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
	}

	/**
	 * Called when a Wand of the Forest is used on this sub tile. Note that the
	 * player parameter can be null if this is called from a dispenser.
	 */
	public boolean onWanded(class_1657 player, class_1799 wand) {
		return false;
	}

	/**
	 * Called when this sub tile is placed in the world (by an entity).
	 */
	public void onBlockPlacedBy(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {}

	/**
	 * Gets the block coordinates this is bound to, for use with the wireframe render
	 * when the sub tile is being hovered with a wand of the forest.
	 */
	@Environment(EnvType.CLIENT)
	@Override
	public class_2338 getBinding() {
		return null;
	}

	/**
	 * Returns a descriptor for the radius of this sub tile. This is called while a player
	 * is looking at the block with a Manaseer Monocle.
	 */
	@Nullable
	public RadiusDescriptor getRadius() {
		return null;
	}

	/**
	 * Returns a descriptor for this flower's secondary radius.
	 * Use for e.g. when a flower has different ranges for picking up and using dropped items.
	 * Called when the player is looking at the block with a Manaseer Monocle.
	 */
	@Nullable
	public RadiusDescriptor getSecondaryRadius() {
		return null;
	}

	/**
	 * @see IWandBindable#canSelect(class_1657, class_1799, net.minecraft.class_2338, class_2350)
	 */
	@Override
	public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		return false;
	}

	/**
	 * @see IWandBindable#bindTo(class_1657, class_1799, net.minecraft.class_2338, class_2350)
	 */
	@Override
	public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		return false;
	}

	/**
	 * Called on the client when the block being pointed at is the one with this sub tile.
	 * Used to render a HUD portraying some data from this sub tile.
	 */
	@Environment(EnvType.CLIENT)
	public void renderHUD(class_4587 ms, class_310 mc) {}

	/**
	 * Gets if this SubTileEntity is affected by Enchanted Soil's speed boost.
	 */
	public boolean isOvergrowthAffected() {
		return true;
	}

	/**
	 * Allow for the SubTile to be "slowed down".
	 * Slowing down is the action that happens when a flower is planted in Podzol or Mycellium.
	 * Any flowers that pick up items from the ground should have a delay on the time the item
	 * needs to be on the floor equal to the value of this method..
	 */
	public int getSlowdownFactor() {
		if (isFloating()) {
			IFloatingFlower.IslandType type = floatingData.getIslandType();
			if (type == IFloatingFlower.IslandType.MYCEL) {
				return SLOWDOWN_FACTOR_MYCEL;
			} else if (type == IFloatingFlower.IslandType.PODZOL) {
				return SLOWDOWN_FACTOR_PODZOL;
			}
		} else {
			class_2248 below = field_11863.method_8320(method_11016().method_10074()).method_26204();
			if (below == class_2246.field_10402) {
				return SLOWDOWN_FACTOR_MYCEL;
			}

			if (below == class_2246.field_10520) {
				return SLOWDOWN_FACTOR_PODZOL;
			}
		}

		return 0;
	}

	@Nullable
	@Override
	public Object getRenderAttachmentData() {
		if (isFloating()) {
			return floatingData;
		}
		return null;
	}
}
