/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.subtile;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaCollector;

/**
 * The basic class for a Generating Flower.
 */
public class TileEntityGeneratingFlower extends TileEntitySpecialFlower {
	private static final class_2960 SPREADER_ID = new class_2960(BotaniaAPI.MODID, "mana_spreader");

	public static final int LINK_RANGE = 6;

	private static final String TAG_MANA = "mana";

	private static final String TAG_COLLECTOR_X = "collectorX";
	private static final String TAG_COLLECTOR_Y = "collectorY";
	private static final String TAG_COLLECTOR_Z = "collectorZ";
	public static final String TAG_PASSIVE_DECAY_TICKS = "passiveDecayTicks";

	private int mana;

	int sizeLastCheck = -1;
	protected class_2586 linkedCollector = null;
	public int passiveDecayTicks;

	class_2338 cachedCollectorCoordinates = null;

	public TileEntityGeneratingFlower(class_2591<?> type) {
		super(type);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		linkCollector();

		if (!method_10997().field_9236 && canGeneratePassively()) {
			int delay = getDelayBetweenPassiveGeneration();
			if (delay > 0 && ticksExisted % delay == 0) {
				addMana(getValueForPassiveGeneration());
			}
		}
		emptyManaIntoCollector();

		if (method_10997().field_9236) {
			double particleChance = 1F - (double) getMana() / (double) getMaxMana() / 3.5F;
			int color = getColor();
			float red = (color >> 16 & 0xFF) / 255F;
			float green = (color >> 8 & 0xFF) / 255F;
			float blue = (color & 0xFF) / 255F;

			if (Math.random() > particleChance) {
				class_243 offset = method_10997().method_8320(method_11016()).method_26226(method_10997(), method_11016());
				double x = method_11016().method_10263() + offset.field_1352;
				double y = method_11016().method_10264() + offset.field_1351;
				double z = method_11016().method_10260() + offset.field_1350;
				BotaniaAPI.instance().sparkleFX(method_10997(), x + 0.3 + Math.random() * 0.5, y + 0.5 + Math.random() * 0.5, z + 0.3 + Math.random() * 0.5, red, green, blue, (float) Math.random(), 5);
			}
		} else {
			boolean passive = isPassiveFlower();
			int muhBalance = BotaniaAPI.instance().getPassiveFlowerDecay();

			if (passive) {
				passiveDecayTicks++;
			}

			if (passive && muhBalance > 0 && passiveDecayTicks > muhBalance) {
				method_10997().method_22352(method_11016(), false);
				if (class_2246.field_10428.method_9564().method_26184(method_10997(), method_11016())) {
					method_10997().method_8501(method_11016(), class_2246.field_10428.method_9564());
				}
			}
		}
	}

	public void linkCollector() {
		boolean needsNew = false;
		if (linkedCollector == null) {
			needsNew = true;

			if (cachedCollectorCoordinates != null) {
				needsNew = false;
				if (method_10997().method_22340(cachedCollectorCoordinates)) {
					needsNew = true;
					class_2586 tileAt = method_10997().method_8321(cachedCollectorCoordinates);
					if (tileAt instanceof IManaCollector && !tileAt.method_11015()) {
						linkedCollector = tileAt;
						needsNew = false;
					}
					cachedCollectorCoordinates = null;
				}
			}
		} else {
			class_2586 tileAt = method_10997().method_8321(linkedCollector.method_11016());
			if (tileAt instanceof IManaCollector) {
				linkedCollector = tileAt;
			}
		}

		if (needsNew && ticksExisted == 1) { // New flowers only
			IManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
			int size = network.getAllCollectorsInWorld(method_10997()).size();
			if (BotaniaAPI.instance().shouldForceCheck() || size != sizeLastCheck) {
				linkedCollector = network.getClosestCollector(method_11016(), method_10997(), LINK_RANGE);
				sizeLastCheck = size;
			}
		}
	}

	public void linkToForcefully(class_2586 collector) {
		linkedCollector = collector;
	}

	public void addMana(int mana) {
		this.mana = Math.min(getMaxMana(), this.getMana() + mana);
		method_5431();
	}

	public void emptyManaIntoCollector() {
		if (isValidBinding()) {
			IManaCollector collector = (IManaCollector) linkedCollector;
			if (!collector.isFull() && getMana() > 0) {
				int manaval = Math.min(getMana(), collector.getMaxMana() - collector.getCurrentMana());
				addMana(-manaval);
				collector.receiveMana(manaval);
				sync();
			}
		}
	}

	public boolean isPassiveFlower() {
		return false;
	}

	public boolean canGeneratePassively() {
		return false;
	}

	public int getDelayBetweenPassiveGeneration() {
		return 20;
	}

	public int getValueForPassiveGeneration() {
		return 1;
	}

	@Override
	public boolean onWanded(class_1657 player, class_1799 wand) {
		if (player == null) {
			return false;
		}

		if (!player.field_6002.field_9236) {
			sync();
		}

		class_2378.field_11156.method_17966(DING_SOUND_EVENT).ifPresent(evt -> player.method_5783(evt, 0.1F, 1F));

		return super.onWanded(player, wand);
	}

	public int getMaxMana() {
		return 20;
	}

	public int getColor() {
		return 0xFFFFFF;
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		mana = cmp.method_10550(TAG_MANA);
		passiveDecayTicks = cmp.method_10550(TAG_PASSIVE_DECAY_TICKS);

		int x = cmp.method_10550(TAG_COLLECTOR_X);
		int y = cmp.method_10550(TAG_COLLECTOR_Y);
		int z = cmp.method_10550(TAG_COLLECTOR_Z);

		cachedCollectorCoordinates = y < 0 ? null : new class_2338(x, y, z);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_MANA, getMana());
		cmp.method_10569(TAG_TICKS_EXISTED, ticksExisted);
		cmp.method_10569(TAG_PASSIVE_DECAY_TICKS, passiveDecayTicks);

		if (cachedCollectorCoordinates != null) {
			cmp.method_10569(TAG_COLLECTOR_X, cachedCollectorCoordinates.method_10263());
			cmp.method_10569(TAG_COLLECTOR_Y, cachedCollectorCoordinates.method_10264());
			cmp.method_10569(TAG_COLLECTOR_Z, cachedCollectorCoordinates.method_10260());
		} else {
			int x = linkedCollector == null ? 0 : linkedCollector.method_11016().method_10263();
			int y = linkedCollector == null ? -1 : linkedCollector.method_11016().method_10264();
			int z = linkedCollector == null ? 0 : linkedCollector.method_11016().method_10260();

			cmp.method_10569(TAG_COLLECTOR_X, x);
			cmp.method_10569(TAG_COLLECTOR_Y, y);
			cmp.method_10569(TAG_COLLECTOR_Z, z);
		}
	}

	@Override
	public class_2338 getBinding() {
		if (linkedCollector == null) {
			return null;
		}
		return linkedCollector.method_11016();
	}

	@Override
	public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		return true;
	}

	@Override
	public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		int range = 6;
		range *= range;

		double dist = pos.method_10262(method_11016());
		if (range >= dist) {
			class_2586 tile = player.field_6002.method_8321(pos);
			if (tile instanceof IManaCollector) {
				linkedCollector = tile;
				sync();
				return true;
			}
		}

		return false;
	}

	public boolean isValidBinding() {
		return linkedCollector != null && !linkedCollector.method_11015() && method_10997().method_8321(linkedCollector.method_11016()) == linkedCollector;
	}

	public class_1799 getHudIcon() {
		return class_2378.field_11142.method_17966(SPREADER_ID).map(class_1799::new).orElse(class_1799.field_8037);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc) {
		String name = class_1074.method_4662(method_11010().method_26204().method_9539());
		int color = getColor();
		BotaniaAPIClient.instance().drawComplexManaHUD(ms, color, getMana(), getMaxMana(), name, getHudIcon(), isValidBinding());
	}

	@Override
	public boolean isOvergrowthAffected() {
		return !isPassiveFlower();
	}

	public int getMana() {
		return mana;
	}
}
